/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.compactor;

import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.renderer.RenderScreenTooltips;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.screen.compactor.CompactorMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CompactorScreen
extends AbstractContainerScreen<CompactorMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"infinity_nexus_mod", (String)"textures/gui/compactor_gui.png");
    private EnergyInfoArea energyInfoArea;
    protected int imageWidth = 176;
    protected int imageHeight = 172;

    public CompactorScreen(CompactorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
    }

    private void assignEnergyInfoArea() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 27, y + 61, ((CompactorMenu)this.menu).getBlockEntity().getEnergyStorage(null), 68, 7);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, 8, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, this.title, 8, -14, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 27, 61, 68, 7)) {
            pGuiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (Screen.hasShiftDown()) {
            if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 96, 53, 18, 18)) {
                RenderScreenTooltips.renderComponentSlotTooltipAndItems((Font)this.font, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 12, 2, 154, 52)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Input Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 148, 52, 18, 18)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x + 2, y - 14, 2, this.imageHeight, this.imageWidth - 4, 64);
        guiGraphics.blit(TEXTURE, x, y - 2, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.renderHorizontal(guiGraphics);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((CompactorMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 115, y + 62, 176, 0, ((CompactorMenu)this.menu).getScaledProgress(), 7);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }
}

