/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.condenser;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.screen.BaseAbstractContainerMenu;
import com.Infinity.Nexus.Core.slots.ComponentSlot;
import com.Infinity.Nexus.Core.slots.ResultSlot;
import com.Infinity.Nexus.Mod.block.ModBlocksAdditions;
import com.Infinity.Nexus.Mod.block.entity.MatterCondenserBlockEntity;
import com.Infinity.Nexus.Mod.screen.ModMenuTypes;
import com.Infinity.Nexus.Mod.slots.ResidualMatterSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CondenserMenu
extends BaseAbstractContainerMenu {
    public final MatterCondenserBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int slots = 3;

    public CondenserMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, (MatterCondenserBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(4), new RestrictedItemStackHandler(3));
    }

    public CondenserMenu(int pContainerId, Inventory inv, MatterCondenserBlockEntity entity, ContainerData data, RestrictedItemStackHandler iItemHandler) {
        super((MenuType)ModMenuTypes.MATTER_CONDENSER_MENU.get(), pContainerId, 3);
        CondenserMenu.checkContainerSize((Container)inv, (int)3);
        this.blockEntity = entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new ResidualMatterSlot(iItemHandler, 0, 80, 6));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 1, 80, 52));
        this.addSlot((Slot)new ComponentSlot(iItemHandler, 2, 8, 29));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public MatterCondenserBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 62;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean stillValid(Player pPlayer) {
        return CondenserMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocksAdditions.MATTER_CONDENSER.get()));
    }
}

