/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.fermentation;

import com.Infinity.Nexus.Core.renderer.FluidTankRenderer;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.block.entity.FermentationBarrelBlockEntity;
import com.Infinity.Nexus.Mod.screen.fermentation.FermentationBarrelMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermentationBarrelScreen
extends AbstractContainerScreen<FermentationBarrelMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"infinity_nexus_mod", (String)"textures/gui/fermentation_barrel_gui.png");
    private FluidTankRenderer fluidRenderer;

    public FermentationBarrelScreen(FermentationBarrelMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignFluidTank();
    }

    private void assignFluidTank() {
        this.fluidRenderer = new FluidTankRenderer(FermentationBarrelBlockEntity.getInputFluidCapacity(), true, 16, 62);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle.getString(), 8, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, ((FermentationBarrelMenu)this.menu).isCrafting() ? "Fermenting" : "Standing By", 98, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, this.title, 8, -9, 0xFFFFFF);
        this.renderFluidAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y, ((FermentationBarrelMenu)this.menu).blockEntity.getFluidHandler(null).getFluidInTank(0), 62, 6, this.fluidRenderer);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrow(guiGraphics, x, y);
        this.fluidRenderer.render(guiGraphics, x + 62, y + 6, ((FermentationBarrelMenu)this.menu).blockEntity.getFluidHandler(null).getFluidInTank(0));
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((FermentationBarrelMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 93, y + 51, 186, 27, -10, -((FermentationBarrelMenu)this.menu).getScaledProgress());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderFluidAreaTooltips(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.renderTooltip(this.font, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.NORMAL), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)renderer.getWidth(), (int)renderer.getHeight());
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }
}

