/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.generator;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.screen.BaseAbstractContainerMenu;
import com.Infinity.Nexus.Core.slots.ComponentSlot;
import com.Infinity.Nexus.Core.slots.FuelSlot;
import com.Infinity.Nexus.Core.slots.UpgradeSlot;
import com.Infinity.Nexus.Mod.block.ModBlocksAdditions;
import com.Infinity.Nexus.Mod.block.entity.GeneratorBlockEntity;
import com.Infinity.Nexus.Mod.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GeneratorMenu
extends BaseAbstractContainerMenu {
    public final GeneratorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int slots = 6;

    public GeneratorMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, (GeneratorBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2), new RestrictedItemStackHandler(6));
    }

    public GeneratorMenu(int pContainerId, Inventory inv, GeneratorBlockEntity entity, ContainerData data, RestrictedItemStackHandler iItemHandler) {
        super((MenuType)ModMenuTypes.GENERATOR_MENU.get(), pContainerId, 6);
        GeneratorMenu.checkContainerSize((Container)inv, (int)6);
        this.blockEntity = entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new FuelSlot(iItemHandler, 0, 80, 47));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 1, -11, 11));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 2, -11, 23));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 3, -11, 35));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 4, -11, 47));
        this.addSlot((Slot)new ComponentSlot(iItemHandler, 5, 8, 29));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public GeneratorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 13;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean stillValid(Player pPlayer) {
        return GeneratorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocksAdditions.GENERATOR.get()));
    }
}

