/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.tank;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.screen.BaseAbstractContainerMenu;
import com.Infinity.Nexus.Core.slots.InputSlot;
import com.Infinity.Nexus.Core.slots.ResultSlot;
import com.Infinity.Nexus.Core.slots.UpgradeSlot;
import com.Infinity.Nexus.Mod.block.ModBlocksAdditions;
import com.Infinity.Nexus.Mod.block.entity.TankBlockEntity;
import com.Infinity.Nexus.Mod.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TankMenu
extends BaseAbstractContainerMenu {
    public final TankBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int slots = 3;

    public TankMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, (TankBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2), new RestrictedItemStackHandler(3));
    }

    public TankMenu(int pContainerId, Inventory inv, TankBlockEntity entity, ContainerData data, RestrictedItemStackHandler iItemHandler) {
        super((MenuType)ModMenuTypes.TANK_MENU.get(), pContainerId, 3);
        TankMenu.checkContainerSize((Container)inv, (int)3);
        this.blockEntity = entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new InputSlot(iItemHandler, 0, 116, 11));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 1, 116, 47));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 2, -11, 29));
        this.addDataSlots(data);
    }

    public int getFluidCount() {
        return this.data.get(1);
    }

    public TankBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean stillValid(Player pPlayer) {
        return TankMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocksAdditions.TANK.get()));
    }
}

