/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EntityCentralizer
extends CarpetBlock {
    public EntityCentralizer(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void entityInside(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pEntity instanceof Mob) {
            Mob mob = (Mob)pEntity;
            try {
                mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 5, false, false));
                double blockX = (double)pPos.getX() + 0.5;
                double blockZ = (double)pPos.getZ() + 0.5;
                double mobX = mob.getX();
                double mobZ = mob.getZ();
                float factor = 0.1f;
                if (mobZ > blockZ) {
                    mob.absMoveTo(mobX, mob.getY(), mobZ - (double)factor);
                    if (mobX > blockX) {
                        mob.absMoveTo(mobX - (double)factor, mob.getY(), mobZ);
                    }
                }
                if (mobZ < blockZ) {
                    mob.absMoveTo(mobX, mob.getY(), mobZ + (double)factor);
                    if (mobX < blockX) {
                        mob.absMoveTo(mobX + (double)factor, mob.getY(), mobZ);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)14.0), Block.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0, (double)16.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public boolean canSurvive(BlockState p_152922_, LevelReader p_152923_, BlockPos p_152924_) {
        return true;
    }
}

