/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.BaseMachineBlock;
import com.Infinity.Nexus.Mod.block.entity.InfuserBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Infuser
extends BaseMachineBlock {
    public static final MapCodec<BaseEntityBlock> CODEC = Infuser.simpleCodec(Infuser::new);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public Infuser(BlockBehaviour.Properties pProperties) {
        super(pProperties, CODEC);
    }

    @Override
    protected void dropContents(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof InfuserBlockEntity) {
            ((InfuserBlockEntity)blockEntity).drops();
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        InfuserBlockEntity blockEntity = (InfuserBlockEntity)level.getBlockEntity(pos);
        if (player.getMainHandItem().isEmpty()) {
            blockEntity.removeStack(player, player.isShiftKeyDown() ? 0 : 1);
        }
        if (!player.isShiftKeyDown()) {
            blockEntity.addStack(player.getMainHandItem().copy(), player);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new InfuserBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Infuser.createTickerHelper(pBlockEntityType, ModBlockEntities.INFUSER_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    @Override
    protected String[] getDescription() {
        return new String[]{Component.literal((String)"\u00a7bInfuser Build Example").getString(), Component.literal((String)"\u00a74\u00a7n[]\u00a7f = \u00a74").append((Component)Component.translatable((String)"block.infinity_nexus_mod.infuser")).getString(), Component.literal((String)"\u00a75[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.magic_pedestal")).getString(), Component.literal((String)"\u00a7e[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.resource_pedestal")).getString(), Component.literal((String)"\u00a78[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.decor_pedestal")).getString(), Component.literal((String)"\u00a73[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.tech_pedestal")).getString(), Component.literal((String)"\u00a76[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.creativity_pedestal")).getString(), Component.literal((String)"\u00a72[]\u00a7f = ").append((Component)Component.translatable((String)"block.infinity_nexus_mod.exploration_pedestal")).getString(), Component.literal((String)" ").getString(), Component.literal((String)"\u00a7f[][]\u00a75[]\u00a7f[][]").getString(), Component.literal((String)"\u00a7e[]\u00a7f[][][]\u00a78[]").getString(), Component.literal((String)"\u00a7f[][]\u00a74[]\u00a7f[][]").getString(), Component.literal((String)"\u00a73[]\u00a7f[][][]\u00a76[]").getString(), Component.literal((String)"\u00a7f[][]\u00a72[]\u00a7f[][]").getString()};
    }
}

