/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMenuProviderBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    protected int[] INPUT_SLOT;
    protected int OUTPUT_SLOT;
    protected int[] UPGRADE_SLOTS;
    protected int COMPONENT_SLOT;
    protected int ENERGY_CAPACITY;
    protected int ENERGY_TRANSFER;
    protected int progress = 0;
    protected int maxProgress = 0;
    protected ContainerData data;
    protected Component displayName;
    protected ModEnergyStorage ENERGY_STORAGE;

    public BaseMenuProviderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, Component displayName, int[] INPUT_SLOT, int OUTPUT_SLOT, int[] UPGRADE_SLOTS, int COMPONENT_SLOT, int ENERGY_CAPACITY, int ENERGY_TRANSFER) {
        super(type, pos, blockState);
        this.displayName = displayName;
        this.INPUT_SLOT = INPUT_SLOT;
        this.OUTPUT_SLOT = OUTPUT_SLOT;
        this.UPGRADE_SLOTS = UPGRADE_SLOTS;
        this.COMPONENT_SLOT = COMPONENT_SLOT;
        this.ENERGY_CAPACITY = ENERGY_CAPACITY;
        this.ENERGY_TRANSFER = ENERGY_TRANSFER;
        this.ENERGY_STORAGE = ENERGY_CAPACITY <= 0 ? null : this.createEnergyStorage();
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> BaseMenuProviderBlockEntity.this.progress;
                    case 1 -> BaseMenuProviderBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        BaseMenuProviderBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        BaseMenuProviderBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void dropContents(Level level, BlockPos worldPosition, ItemStackHandler itemHandler) {
        SimpleContainer inventory = new SimpleContainer(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            inventory.setItem(i, itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }

    protected ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(this.ENERGY_CAPACITY, this.ENERGY_TRANSFER){

            public void onEnergyChanged() {
                BaseMenuProviderBlockEntity.this.setChanged();
                if (BaseMenuProviderBlockEntity.this.level != null) {
                    BaseMenuProviderBlockEntity.this.level.sendBlockUpdated(BaseMenuProviderBlockEntity.this.getBlockPos(), BaseMenuProviderBlockEntity.this.getBlockState(), BaseMenuProviderBlockEntity.this.getBlockState(), 4);
                }
            }
        };
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    protected boolean canTick(ItemStackHandler itemHandler) {
        if (itemHandler.getStackInSlot(this.getComponentSlot()).isEmpty()) {
            return false;
        }
        for (int slot : this.getInputSlot()) {
            if (!itemHandler.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    protected boolean hasProgressFinished() {
        this.data.set(0, this.progress);
        return this.progress >= this.maxProgress;
    }

    protected void increaseCraftingProgress() {
        this.data.set(0, this.progress);
        ++this.progress;
    }

    protected void resetProgress() {
        this.data.set(0, 0);
        this.progress = 0;
    }

    public int[] getInputSlot() {
        return this.INPUT_SLOT;
    }

    public int getOutputSlot() {
        return this.OUTPUT_SLOT;
    }

    public int[] getUpgradeSlot() {
        return this.UPGRADE_SLOTS;
    }

    public int getComponentSlot() {
        return this.COMPONENT_SLOT;
    }
}

