/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.InfinityNexusCore;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Mod.block.custom.Battery;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.GeneratorBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.SolarBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.TranslocatorEnergyBlockEntity;
import com.Infinity.Nexus.Mod.component.ItemStackComponent;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.battery.BatteryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryBlockEntity
extends BaseMenuProviderBlockEntity {
    protected ModEnergyStorage BATTERY_ENERGY_STORAGE = this.createEnergyStorage();
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            BatteryBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> ((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).canReceive();
                case 2, 3, 4, 5 -> ModUtils.isUpgrade((ItemStack)stack);
                case 6 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };

    public BatteryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.BATTERY_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.battery"), new int[]{0}, 1, new int[]{2, 3, 4, 5}, 6, ConfigUtils.battery_energy_storage_capacity, ConfigUtils.battery_energy_transfer_rate);
    }

    @Override
    protected ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(this.ENERGY_CAPACITY, this.ENERGY_TRANSFER){

            public void onEnergyChanged() {
                BatteryBlockEntity.this.setChanged();
                if (BatteryBlockEntity.this.level != null) {
                    BatteryBlockEntity.this.level.sendBlockUpdated(BatteryBlockEntity.this.getBlockPos(), BatteryBlockEntity.this.getBlockState(), BatteryBlockEntity.this.getBlockState(), 4);
                }
            }

            public int getMaxEnergyStored() {
                int machineLevel = BatteryBlockEntity.this.getMachineLevel();
                return (int)((double)BatteryBlockEntity.this.ENERGY_CAPACITY * Math.pow((double)(machineLevel + 1) / 10.0, 1.5));
            }

            public int getEnergyStored() {
                int energy = Math.min(super.getEnergyStored(), this.getMaxEnergyStored());
                this.setEnergy(energy);
                return energy;
            }
        };
    }

    public void drops() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock().asItem());
        stack = BatteryBlockEntity.storageComponentAndEnergy(stack, (EnergyStorage)this.BATTERY_ENERGY_STORAGE, this.itemHandler, this.COMPONENT_SLOT);
        ItemEntity battery = new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), stack);
        this.level.addFreshEntity((Entity)battery);
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("battery.progress", this.progress);
        pTag.putInt("battery.energy", this.BATTERY_ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("battery.progress");
        this.BATTERY_ENERGY_STORAGE.setEnergy(pTag.getInt("battery.energy"));
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.battery").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new BatteryMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.BATTERY_ENERGY_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Battery.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.itemHandler.getStackInSlot(this.COMPONENT_SLOT).isEmpty()) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)9, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)1);
        this.data.set(1, this.maxProgress);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        this.distributeEnergy();
        this.fillDrainEnergyItem();
        this.increaseCraftingProgress();
        BatteryBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.above(), (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void fillDrainEnergyItem() {
        EnergyUtils.fillItem((IEnergyStorage)this.BATTERY_ENERGY_STORAGE, (RestrictedItemStackHandler)this.itemHandler, (int)this.INPUT_SLOT[0], (int)this.OUTPUT_SLOT, (int)1000);
    }

    private boolean hasEnoughEnergy() {
        return this.BATTERY_ENERGY_STORAGE.getEnergyStored() >= 1;
    }

    private void distributeEnergy() {
        if (this.level == null || this.level.isClientSide() || this.BATTERY_ENERGY_STORAGE.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            BlockEntity neighborBlockEntity = this.level.getBlockEntity(neighborPos);
            if (neighborBlockEntity == null || neighborBlockEntity instanceof SolarBlockEntity || neighborBlockEntity instanceof GeneratorBlockEntity || neighborBlockEntity instanceof TranslocatorEnergyBlockEntity || neighborBlockEntity instanceof BatteryBlockEntity) continue;
            try {
                IEnergyStorage neighborStorage = EnergyUtils.getBlockCapabilityEnergyHandler((Level)this.level, (BlockPos)neighborPos, (Direction)direction);
                if (neighborStorage == null) continue;
                EnergyUtils.transferEnergy((IEnergyStorage)this.BATTERY_ENERGY_STORAGE, (IEnergyStorage)neighborStorage, (int)this.ENERGY_TRANSFER);
            }
            catch (Exception e) {
                InfinityNexusCore.LOGGER.error("Failed to transfer energy to neighbor at {}: {}", (Object)neighborPos, (Object)e.getMessage());
            }
        }
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }

    public void setEnergyAndComponent(ItemStack stack) {
        int energy;
        ItemStackComponent itemStack;
        ItemStackComponent itemStackComponent = itemStack = stack.has(ModDataComponents.ITEM_STACK) ? (ItemStackComponent)stack.get(ModDataComponents.ITEM_STACK) : null;
        if (itemStack != null) {
            ItemStackHandlerUtils.setStackInSlot((int)this.COMPONENT_SLOT, (ItemStack)itemStack.itemStack().copy(), (RestrictedItemStackHandler)this.itemHandler);
        }
        if ((energy = ((Integer)stack.getOrDefault(ModDataComponents.ENERGY, (Object)0)).intValue()) > 0) {
            this.fillRecursively(energy);
        }
    }

    private void fillRecursively(int remainingEnergy) {
        int transfer = Math.min(remainingEnergy, this.ENERGY_TRANSFER);
        int actuallyInserted = EnergyUtils.insertEnergy((IEnergyStorage)this.BATTERY_ENERGY_STORAGE, (int)transfer, (boolean)false);
        int newRemaining = remainingEnergy - actuallyInserted;
        if (newRemaining > 0) {
            this.fillRecursively(newRemaining);
        }
    }
}

