/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.GetNewAABB;
import com.Infinity.Nexus.Mod.block.custom.Compactor;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.recipe.CompactorRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CompactorBlockEntity
extends BaseBlockEntity {
    private boolean redstone = false;
    private int progress = 0;
    private int maxProgress = 100;
    AABB aabb = GetNewAABB.getAABB((double)(this.worldPosition.getX() - 1), (double)(this.worldPosition.getY() - 1), (double)(this.worldPosition.getZ() - 1), (double)(this.worldPosition.getX() + 2), (double)(this.worldPosition.getY() + 3), (double)(this.worldPosition.getZ() + 2));

    public CompactorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.COMPACTOR_BE.get(), pPos, pBlockState);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        boolean isPowered = this.isRedstonePowered(pPos);
        if (this.progress < this.maxProgress) {
            ++this.progress;
        } else {
            this.progress = 0;
            this.verifySpace(pLevel, pPos);
        }
        if (isPowered != this.redstone) {
            this.redstone = isPowered;
            if (isPowered && this.verifySpace(pLevel, pPos)) {
                this.craft(pLevel, pPos);
            }
        }
        this.setChanged();
    }

    private void craft(Level pLevel, BlockPos pPos) {
        Optional<RecipeHolder<CompactorRecipes>> recipe = this.getCurrentRecipe();
        if (!recipe.isEmpty()) {
            List entities = this.level.getEntitiesOfClass(ItemEntity.class, this.aabb);
            ServerLevel level = (ServerLevel)this.getLevel();
            if (!entities.isEmpty()) {
                ((ItemEntity)entities.get(0)).remove(Entity.RemovalReason.DISCARDED);
                ItemStack result = ((CompactorRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)pLevel.registryAccess());
                ItemEntity output = new ItemEntity((Level)level, (double)pPos.getX(), (double)(pPos.getY() + 2), (double)pPos.getZ(), result.copy());
                level.addFreshEntity((Entity)output);
                this.removeBlocks();
            }
        }
    }

    private boolean verifySpace(Level pLevel, BlockPos pPos) {
        boolean free = true;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos adjacentPos;
                BlockState adjacentState;
                if (x == 0 && z == 0 || (adjacentState = pLevel.getBlockState(adjacentPos = pPos.offset(x, 0, z))).getBlock() == Blocks.BARRIER) continue;
                free = false;
            }
        }
        if (free) {
            pLevel.setBlock(pPos, (BlockState)this.getBlockState().setValue((Property)Compactor.LIT, (Comparable)Integer.valueOf(0)), 3);
        } else {
            pLevel.setBlock(pPos, (BlockState)this.getBlockState().setValue((Property)Compactor.LIT, (Comparable)Integer.valueOf(1)), 3);
        }
        return free;
    }

    private void removeBlocks() {
        int centerX = this.worldPosition.getX();
        int centerY = this.worldPosition.getY() + 2;
        int centerZ = this.worldPosition.getZ();
        BlockPos center = new BlockPos(centerX, centerY, centerZ);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y >= -1; --y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = new BlockPos(centerX + x, centerY + y, centerZ + z);
                    if (center.equals((Object)pos)) continue;
                    this.level.destroyBlock(pos, false);
                }
            }
        }
    }

    private Optional<RecipeHolder<CompactorRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(27);
        int centerX = this.worldPosition.getX();
        int centerY = this.worldPosition.getY() + 2;
        int centerZ = this.worldPosition.getZ();
        int index = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    BlockPos pos = new BlockPos(centerX + x, centerY + y, centerZ + z);
                    if (x == 0 && y == 0 && z == 0) {
                        ItemStack centerItem;
                        List entities = this.level.getEntitiesOfClass(ItemEntity.class, this.aabb);
                        if (entities.isEmpty() || (centerItem = ((ItemEntity)entities.get(0)).getItem()).getCount() != 1) continue;
                        inventory.setItem(index++, centerItem);
                        continue;
                    }
                    BlockState state = this.level.getBlockState(pos);
                    ItemStack item = new ItemStack((ItemLike)state.getBlock().asItem());
                    inventory.setItem(index++, item);
                }
            }
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.COMPACTOR_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 27), this.level);
    }

    @Override
    protected boolean isRedstonePowered(BlockPos pPos) {
        return this.level.hasNeighborSignal(pPos.north()) || this.level.hasNeighborSignal(pPos.south()) || this.level.hasNeighborSignal(pPos.west()) || this.level.hasNeighborSignal(pPos.east());
    }
}

