/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Crusher;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.CrusherRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.screen.crusher.CrusherMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrusherBlockEntity
extends BaseMenuProviderBlockEntity {
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            CrusherBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> false;
                case 2, 3, 4, 5 -> ModUtils.isUpgrade((ItemStack)stack);
                case 6 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };

    public CrusherBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.CRUSHER_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.crusher"), new int[]{0}, 1, new int[]{2, 3, 4, 5}, 6, ConfigUtils.crusher_energy_storage_capacity, ConfigUtils.crusher_energy_transfer_rate);
    }

    @Override
    public Component getDisplayName() {
        return super.getDisplayName().copy().append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CrusherMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.saveAdditional(pTag, registries);
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("crusher.progress", this.progress);
        pTag.putInt("crusher.energy", this.ENERGY_STORAGE.getEnergyStored());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("crusher.progress");
        this.ENERGY_STORAGE.setEnergy(tag.getInt("crusher.energy"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Crusher.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (!this.canTick((ItemStackHandler)this.itemHandler)) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        Optional<RecipeHolder<CrusherRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            this.resetProgress();
            return;
        }
        this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)((CrusherRecipes)recipe.get().value()).getDuration(), (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)ConfigUtils.crusher_minimum_tick);
        this.data.set(1, this.maxProgress);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Crusher.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractRecipeEnergy(recipe);
        this.setChanged();
        if (this.hasProgressFinished()) {
            this.craftItem(machineLevel + 1, recipe);
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.above(), (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractRecipeEnergy(Optional<RecipeHolder<CrusherRecipes>> recipe) {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)((CrusherRecipes)recipe.get().value()).getEnergy(), (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void craftItem(int machineLevel, Optional<RecipeHolder<CrusherRecipes>> recipe) {
        ItemStack result = ((CrusherRecipes)recipe.get().value()).getResultItem(null);
        int duplicate = this.getDuplicationValue(machineLevel, recipe, result);
        ItemStackHandlerUtils.extractItem((int)this.INPUT_SLOT[0], (int)((CrusherRecipes)recipe.get().value()).getCount(), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        result.setCount(result.getCount() + duplicate + this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).getCount());
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        ItemStackHandlerUtils.setStackInSlot((int)this.OUTPUT_SLOT, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (SoundEvent)SoundEvents.BASALT_BREAK);
    }

    private int getDuplicationValue(int machineLevel, Optional<RecipeHolder<CrusherRecipes>> recipe, ItemStack result) {
        int duplicationValue = ((CrusherRecipes)recipe.get().value()).canDuplicate() ? Math.round((float)result.getCount() * ((float)machineLevel / 2.0f)) : result.getCount();
        return duplicationValue > 1 ? duplicationValue : 0;
    }

    private boolean hasRecipe(Optional<RecipeHolder<CrusherRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((CrusherRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)(this.getDuplicationValue(this.getMachineLevel(), recipe, result) + 1), (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private Optional<RecipeHolder<CrusherRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.setItem(0, this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
        inventory.setItem(1, this.itemHandler.getStackInSlot(this.INPUT_SLOT[0]));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.CRUSHER_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 2), this.level);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

