/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DepotBlockEntityBase
extends BlockEntity {
    int timer = 0;
    int maxTimer = 20;
    int count = 1;
    final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DepotBlockEntityBase.this.setChanged();
        }
    };
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    protected final ContainerData data = new ContainerData(){

        public int get(int pIndex) {
            return DepotBlockEntityBase.this.count;
        }

        public void set(int pIndex, int pValue) {
        }

        public int getCount() {
            return DepotBlockEntityBase.this.count;
        }
    };

    public DepotBlockEntityBase(@NotNull BlockEntityType<? extends DepotBlockEntityBase> blockEntityType, BlockPos pPos, BlockState pBlockState) {
        super(blockEntityType, pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.putInt("count", this.count);
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        this.count = pTag.getInt("count");
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (this.canPlace(pPos)) {
            this.place();
            DepotBlockEntityBase.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    protected void place() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty()) {
            ItemStack stack2 = stack.copy();
            stack2.setCount(1);
            ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack2);
            entity.setDeltaMovement(Vec3.ZERO);
            entity.setUnlimitedLifetime();
            entity.setPickUpDelay(10);
            this.level.addFreshEntity((Entity)entity);
            this.itemHandler.getStackInSlot(0).shrink(1);
        }
    }

    protected boolean hasEntity(BlockPos pPos) {
        List entities = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(pPos));
        if (!entities.isEmpty()) {
            entities.forEach(entity -> entity.setPickUpDelay(10));
        }
        return entities.isEmpty();
    }

    boolean hasProgressFinished() {
        this.timer = this.timer < this.maxTimer ? ++this.timer : 0;
        return this.timer >= this.maxTimer;
    }

    protected boolean canPlace(BlockPos pPos) {
        return this.hasEntity(pPos);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public void setStack(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).isEmpty()) {
            this.itemHandler.setStackInSlot(0, itemStack.copy());
            player.getMainHandItem().shrink(player.getMainHandItem().getCount());
        }
    }

    public void setCount(Player player) {
        this.count = this.count < 64 ? this.count + 1 : 1;
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eQuantidade alterada para: " + this.count)));
    }
}

