/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.GetNewAABB;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.entity.DepotBlockEntityBase;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;

public class DepotStoneBlockEntity
extends DepotBlockEntityBase {
    AABB aabb;

    public DepotStoneBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.DEPOT_STONE_BE.get(), pPos, pBlockState);
        this.aabb = GetNewAABB.getAABB((double)(this.worldPosition.getX() - 1), (double)(this.worldPosition.getY() - 1), (double)(this.worldPosition.getZ() - 1), (double)(this.worldPosition.getX() + 2), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 2));
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    protected void place() {
        if (!this.hasProgressFinished()) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.isEmpty()) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos targetPos = this.worldPosition.offset(dx, 0, dz);
                    if (!this.canPlaceHere(targetPos) || targetPos == this.worldPosition) continue;
                    ItemStack stack2 = stack.copy();
                    stack2.setCount(1);
                    ItemEntity entity = new ItemEntity(this.level, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5, stack2);
                    entity.setDeltaMovement(Vec3.ZERO);
                    entity.setUnlimitedLifetime();
                    entity.setPickUpDelay(10);
                    this.level.addFreshEntity((Entity)entity);
                    SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.SCRAPE, (BlockPos)this.worldPosition, (BlockPos)targetPos, (double)0.5, (double)0.2, (double)0.5);
                    this.itemHandler.getStackInSlot(0).shrink(1);
                    return;
                }
            }
        } else {
            this.hasEntities(this.worldPosition);
        }
    }

    protected boolean canPlaceHere(BlockPos pPos) {
        return this.hasEntity(pPos);
    }

    private boolean hasEntities(BlockPos pPos) {
        List entities = this.level.getEntitiesOfClass(ItemEntity.class, this.aabb);
        if (!entities.isEmpty()) {
            entities.forEach(entity -> entity.setPickUpDelay(20));
        }
        return entities.size() < 8;
    }

    @Override
    protected boolean canPlace(BlockPos pPos) {
        return this.hasEntities(pPos);
    }
}

