/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Factory;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.FactoryRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.screen.factory.FactoryMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryBlockEntity
extends BaseMenuProviderBlockEntity {
    private static final int ENERGY_REQ = 32;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(22){

        protected void onContentsChanged(int slot) {
            FactoryBlockEntity.this.setChanged();
            assert (FactoryBlockEntity.this.level != null);
            if (!FactoryBlockEntity.this.level.isClientSide()) {
                FactoryBlockEntity.this.level.sendBlockUpdated(FactoryBlockEntity.this.getBlockPos(), FactoryBlockEntity.this.getBlockState(), FactoryBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 16 -> false;
                case 17, 18, 19, 20 -> ModUtils.isUpgrade((ItemStack)stack);
                case 21 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot <= 7) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 0 || slot > 15) {
                return super.insertItem(slot, stack, simulate);
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (simulate) {
                ItemStack existing = this.getStackInSlot(slot);
                if (existing.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return stack;
            }
            for (int i = 0; i <= 15; ++i) {
                ItemStack existingStack = this.getStackInSlot(i);
                if (!existingStack.isEmpty()) continue;
                ItemStack singleItem = stack.copy();
                singleItem.setCount(1);
                this.setStackInSlot(i, singleItem);
                ItemStack remainder = stack.copy();
                remainder.shrink(1);
                return remainder;
            }
            return stack;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot <= 15) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };

    public FactoryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.FACTORY_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.factory"), new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 16, new int[]{17, 18, 19, 20}, 21, ConfigUtils.factory_energy_storage_capacity, ConfigUtils.factory_energy_transfer_rate);
    }

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(slot).isEmpty() ? ItemStack.EMPTY : this.itemHandler.getStackInSlot(slot);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("factory.progress", this.progress);
        pTag.putInt("factory.maxProgress", this.maxProgress);
        pTag.putInt("factory.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("factory.progress");
        this.maxProgress = pTag.getInt("factory.maxProgress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("factory.energy"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.factory").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FactoryMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Factory.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (!this.canTick((ItemStackHandler)this.itemHandler)) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        Optional<RecipeHolder<FactoryRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            this.resetProgress();
            return;
        }
        this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)((FactoryRecipes)recipe.get().value()).getDuration(), (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)ConfigUtils.factory_minimum_tick);
        this.data.set(1, this.maxProgress);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Factory.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractRecipeEnergy(recipe);
        FactoryBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem(recipe);
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.above(), (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractRecipeEnergy(Optional<RecipeHolder<FactoryRecipes>> recipe) {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)((FactoryRecipes)recipe.get().value()).getEnergy(), (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void craftItem(Optional<RecipeHolder<FactoryRecipes>> recipe) {
        ItemStack result = ((FactoryRecipes)recipe.get().value()).getResultItem(null);
        for (int slot : this.INPUT_SLOT) {
            ItemStackHandlerUtils.extractItem((int)slot, (int)1, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        result.setCount(result.getCount() + this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).getCount());
        ItemStackHandlerUtils.setStackInSlot((int)this.OUTPUT_SLOT, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSoundHideoutMuffler((Level)this.level, (BlockPos)this.worldPosition, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (SoundEvent)SoundEvents.RESPAWN_ANCHOR_AMBIENT);
    }

    private boolean hasRecipe(Optional<RecipeHolder<FactoryRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((FactoryRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private Optional<RecipeHolder<FactoryRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(17);
        inventory.setItem(0, this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
        for (int i = 0; i < 16; ++i) {
            inventory.setItem(i + 1, this.itemHandler.getStackInSlot(i));
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.FACTORY_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 17), this.level);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }

    public IItemHandler getRecipeInventory() {
        return this.itemHandler;
    }
}

