/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.FluidUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.entity.BaseBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.recipe.FermentationBarrelRecipes;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInputWithFluid;
import com.Infinity.Nexus.Mod.screen.fermentation.FermentationBarrelMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            FermentationBarrelBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 2 -> true;
                case 1, 3 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final FluidTank inputFluidHandler;
    private static final int INPUT_FLUID_ITEM = 0;
    private static final int OUTPUT_FLUID_ITEM = 1;
    private static final int INPUT_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    private final FluidTank FLUID_STORAGE = this.inputFluidHandler = new FluidTank(8000){

        public void onContentsChanged() {
            FermentationBarrelBlockEntity.this.setChanged();
            if (!FermentationBarrelBlockEntity.this.level.isClientSide()) {
                FermentationBarrelBlockEntity.this.level.sendBlockUpdated(FermentationBarrelBlockEntity.this.getBlockPos(), FermentationBarrelBlockEntity.this.getBlockState(), FermentationBarrelBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }
    };
    private static final int INPUT_FLUID_CAPACITY = 8000;
    private static final int OUTPUT_FLUID_CAPACITY = 8000;
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    private Lazy<IFluidHandler> lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 0;
    private double nextTarget = (double)this.maxProgress * 0.025;

    public FermentationBarrelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.FERMENTATION_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FermentationBarrelBlockEntity.this.progress;
                    case 1 -> FermentationBarrelBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FermentationBarrelBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FermentationBarrelBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
        this.lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.fermentation_barrel");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FermentationBarrelMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("fermentation_barrel.progress", this.progress);
        pTag.putInt("fermentation_barrel.max_progress", this.maxProgress);
        pTag = this.FLUID_STORAGE.writeToNBT(registries, pTag);
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("fermentation_barrel.progress");
        this.maxProgress = pTag.getInt("fermentation_barrel.max_progress");
        this.FLUID_STORAGE.readFromNBT(registries, pTag);
    }

    public static long getInputFluidCapacity() {
        return 8000L;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return this.FLUID_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        FluidUtils.transferFromItemToTank((FluidTank)this.FLUID_STORAGE, (RestrictedItemStackHandler)this.itemHandler, (int)1, (int)0);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (this.itemHandler.getStackInSlot(2).isEmpty()) {
            return;
        }
        Optional<RecipeHolder<FermentationBarrelRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            this.resetProgress();
            return;
        }
        this.setMaxProgress();
        this.increaseCraftingProgress(pPos);
        FermentationBarrelBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem(recipe);
            this.resetProgress();
        }
    }

    private void setMaxProgress() {
        int time = ((FermentationBarrelRecipes)this.getCurrentRecipe().get().value()).getDuration();
        if (this.level.getBlockState(this.getBlockPos().below()).getBlock() instanceof MyceliumBlock) {
            time /= 2;
        }
        if (this.itemHandler.getStackInSlot(2).getItem() == ModItemsAdditions.INFINITY_INGOT.get()) {
            time *= this.itemHandler.getStackInSlot(2).getCount();
        }
        this.maxProgress = time;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(Optional<RecipeHolder<FermentationBarrelRecipes>> recipe) {
        int recipeFluidInputAmount = ((FermentationBarrelRecipes)recipe.get().value()).getInputFluidStack().getAmount();
        int recipeInputCount = ((FermentationBarrelRecipes)recipe.get().value()).getInputCount();
        int recipeResultCount = ((FermentationBarrelRecipes)recipe.get().value()).getResultItem(null).getCount();
        ItemStack result = ((FermentationBarrelRecipes)recipe.get().value()).getResultItem(null);
        int inputCount = ((FermentationBarrelRecipes)recipe.get().value()).getInputCount();
        int fluidInputCount = ((FermentationBarrelRecipes)recipe.get().value()).getInputFluidStack().getAmount();
        while (this.itemHandler.getStackInSlot(2).getCount() >= inputCount && this.FLUID_STORAGE.getFluidAmount() >= fluidInputCount) {
            FluidUtils.drainFluidFromTank((FluidTank)this.FLUID_STORAGE, (int)recipeFluidInputAmount);
            result.setCount(this.itemHandler.getStackInSlot(3).getCount() + (result.getCount() + recipeResultCount));
            ItemStackHandlerUtils.setStackInSlot((int)3, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
            ItemStackHandlerUtils.extractItem((int)2, (int)recipeInputCount, (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
        SoundUtils.playSound((Level)this.level, (BlockPos)this.worldPosition, (SoundSource)SoundSource.BLOCKS, (SoundEvent)SoundEvents.BREWING_STAND_BREW, (float)1.0f, (float)1.0f);
    }

    private boolean hasRecipe(Optional<RecipeHolder<FermentationBarrelRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((FermentationBarrelRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)3, (RestrictedItemStackHandler)this.itemHandler);
    }

    private Optional<RecipeHolder<FermentationBarrelRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        inventory.setItem(0, this.itemHandler.getStackInSlot(2));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.FERMENTATION_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInputWithFluid(inventory, 1, List.of(this.FLUID_STORAGE.getFluid()), 1), this.level);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress(BlockPos pPos) {
        if ((double)this.progress >= this.nextTarget) {
            double x = (double)pPos.getX() + 0.5;
            double y = pPos.getY() + 1;
            double z = (double)pPos.getZ() + 0.5;
            ServerLevel level = (ServerLevel)this.getLevel();
            level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y + 0.1, z, 1, 0.0, 0.0, 0.0, 0.01);
            this.nextTarget += (double)this.maxProgress * 0.025;
        }
        ++this.progress;
    }

    public static int getInputSlot() {
        return 2;
    }

    public static int getOutputSlot() {
        return 3;
    }
}

