/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.component.CoreDataComponents;
import com.Infinity.Nexus.Core.fakePlayer.IFFakePlayer;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.GetFakePlayer;
import com.Infinity.Nexus.Core.utils.GetNewAABB;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.custom.MobCrusher;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.fluid.ModFluids;
import com.Infinity.Nexus.Mod.screen.mobcrusher.MobCrusherMenu;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobCrusherBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int[] OUTPUT_SLOT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] UPGRADE_SLOTS = new int[]{9, 10, 11, 12};
    private static final int COMPONENT_SLOT = 13;
    private static final int SWORD_SLOT = 14;
    private static final int LINK_SLOT = 15;
    private static final int FUEL_SLOT = 16;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 120;
    private int hasRedstoneSignal = 0;
    private int stillCrafting = 0;
    private int hasSlotFree = 0;
    private int hasComponent = 0;
    private int hasEnoughEnergy = 0;
    private int hasRecipe = 0;
    private int linkx = 0;
    private int linky = 0;
    private int linkz = 0;
    private int linkFace = 0;
    private static final int ENERGY_CAPACITY = 60000;
    private static final int ENERGY_TRANSFER = 640;
    private static final int ENERGY_REQ = 32;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private static final int FluidStorageCapacity = 10000;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(17){

        protected void onContentsChanged(int slot) {
            MobCrusherBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 9, 10, 11, 12 -> ModUtils.isUpgrade((ItemStack)stack);
                case 13 -> ModUtils.isComponent((ItemStack)stack);
                case 14 -> stack.getItem() instanceof SwordItem;
                case 15 -> stack.is(((Item)ModItems.LINKING_TOOL.get()).asItem());
                case 16 -> {
                    if (stack.getBurnTime(null) > 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            return slot <= 8 ? super.extractItem(slot, amount, simulate, false) : super.extractItem(slot, amount, simulate, fromAutomation);
        }
    };
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(60000, 640){

        public void onEnergyChanged() {
            MobCrusherBlockEntity.this.setChanged();
            MobCrusherBlockEntity.this.getLevel().sendBlockUpdated(MobCrusherBlockEntity.this.getBlockPos(), MobCrusherBlockEntity.this.getBlockState(), MobCrusherBlockEntity.this.getBlockState(), 4);
        }
    };
    private Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    private Lazy<IEnergyStorage> lazyEnergyStorage = Lazy.of(() -> this.ENERGY_STORAGE);
    private Lazy<IFluidHandler> lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    private boolean showArea = false;

    private FluidTank createFluidStorage() {
        return new FluidTank(10000){

            protected void onContentsChanged() {
                MobCrusherBlockEntity.this.setChanged();
                if (!MobCrusherBlockEntity.this.getLevel().isClientSide) {
                    MobCrusherBlockEntity.this.getLevel().sendBlockUpdated(MobCrusherBlockEntity.this.getBlockPos(), MobCrusherBlockEntity.this.getBlockState(), MobCrusherBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    public MobCrusherBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.MOBCRUSHER_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> MobCrusherBlockEntity.this.progress;
                    case 1 -> MobCrusherBlockEntity.this.maxProgress;
                    case 2 -> MobCrusherBlockEntity.this.hasRedstoneSignal;
                    case 3 -> MobCrusherBlockEntity.this.stillCrafting;
                    case 4 -> MobCrusherBlockEntity.this.hasSlotFree;
                    case 5 -> MobCrusherBlockEntity.this.hasComponent;
                    case 6 -> MobCrusherBlockEntity.this.hasEnoughEnergy;
                    case 7 -> MobCrusherBlockEntity.this.hasRecipe;
                    case 8 -> MobCrusherBlockEntity.this.linkx;
                    case 9 -> MobCrusherBlockEntity.this.linky;
                    case 10 -> MobCrusherBlockEntity.this.linkz;
                    case 11 -> MobCrusherBlockEntity.this.linkFace;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        MobCrusherBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        MobCrusherBlockEntity.this.maxProgress = pValue;
                        break;
                    }
                    case 2: {
                        MobCrusherBlockEntity.this.hasRedstoneSignal = pValue;
                        break;
                    }
                    case 3: {
                        MobCrusherBlockEntity.this.stillCrafting = pValue;
                        break;
                    }
                    case 4: {
                        MobCrusherBlockEntity.this.hasSlotFree = pValue;
                        break;
                    }
                    case 5: {
                        MobCrusherBlockEntity.this.hasComponent = pValue;
                        break;
                    }
                    case 6: {
                        MobCrusherBlockEntity.this.hasEnoughEnergy = pValue;
                        break;
                    }
                    case 7: {
                        MobCrusherBlockEntity.this.hasRecipe = pValue;
                        break;
                    }
                    case 8: {
                        MobCrusherBlockEntity.this.linkx = pValue;
                        break;
                    }
                    case 9: {
                        MobCrusherBlockEntity.this.linky = pValue;
                        break;
                    }
                    case 10: {
                        MobCrusherBlockEntity.this.linkz = pValue;
                        break;
                    }
                    case 11: {
                        MobCrusherBlockEntity.this.linkFace = pValue;
                    }
                }
            }

            public int getCount() {
                return 12;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = Lazy.of(() -> this.itemHandler);
        this.lazyEnergyStorage = Lazy.of(() -> this.ENERGY_STORAGE);
        this.lazyFluidHandler = Lazy.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("mobCrusher.progress", this.progress);
        pTag.putInt("mobCrusher.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag = this.FLUID_STORAGE.writeToNBT(registries, pTag);
        pTag.putInt("mobCrusher.hasRedstoneSignal", this.getHasRedstoneSignal());
        pTag.putInt("mobCrusher.stillCrafting", this.getStillCrafting());
        pTag.putInt("mobCrusher.hasSlotFree", this.getHasSlotFree());
        pTag.putInt("mobCrusher.hasComponent", this.getHasComponent());
        pTag.putInt("mobCrusher.hasEnoughEnergy", this.getHasEnoughEnergy());
        pTag.putInt("mobCrusher.hasRecipe", this.getHasRecipe());
        pTag.putInt("miner.linkx", this.data.get(8));
        pTag.putInt("miner.linky", this.data.get(9));
        pTag.putInt("miner.linkz", this.data.get(10));
        pTag.putInt("miner.linkFace", this.data.get(11));
        pTag.putBoolean("mobCrusher.showArea", this.showArea);
        super.saveAdditional(pTag, registries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("mobCrusher.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("mobCrusher.energy"));
        this.FLUID_STORAGE.readFromNBT(registries, pTag);
        this.hasRedstoneSignal = pTag.getInt("mobCrusher.hasRedstoneSignal");
        this.stillCrafting = pTag.getInt("mobCrusher.stillCrafting");
        this.hasSlotFree = pTag.getInt("mobCrusher.hasSlotFree");
        this.hasComponent = pTag.getInt("mobCrusher.hasComponent");
        this.hasEnoughEnergy = pTag.getInt("mobCrusher.hasEnoughEnergy");
        this.hasRecipe = pTag.getInt("mobCrusher.hasRecipe");
        this.linkx = pTag.getInt("miner.linkx");
        this.linky = pTag.getInt("miner.linky");
        this.linkz = pTag.getInt("miner.linkz");
        this.linkFace = pTag.getInt("miner.linkFace");
        this.showArea = pTag.getBoolean("mobCrusher.showArea");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.mob_crusher").append(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        return new MobCrusherMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public static int getComponentSlot() {
        return 13;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public IFluidHandler getFluidHandler(Direction direction) {
        return this.FLUID_STORAGE;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static long getFluidCapacity() {
        return 10000L;
    }

    public FluidStack getFluid() {
        return this.FLUID_STORAGE.getFluid();
    }

    public int getHasRedstoneSignal() {
        return this.data.get(2);
    }

    public int getStillCrafting() {
        return this.data.get(3);
    }

    public int getHasSlotFree() {
        return this.data.get(4);
    }

    public int getHasComponent() {
        return this.data.get(5);
    }

    public int getHasEnoughEnergy() {
        return this.data.get(6);
    }

    public int getHasRecipe() {
        return this.data.get(7);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        this.renderAreaPreview(level, pos);
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        state = (BlockState)state.setValue((Property)MobCrusher.LIT, (Comparable)Integer.valueOf(machineLevel));
        if (this.isRedstonePowered(pos)) {
            this.data.set(2, 1);
            return;
        }
        this.data.set(2, 0);
        this.setMaxProgress();
        if (!this.hasEnoughEnergy()) {
            this.verifySolidFuel();
            this.data.set(6, 0);
            return;
        }
        this.data.set(6, 1);
        if (this.hasMobInside(machineLevel, pos, level)) {
            this.data.set(7, 1);
            this.increaseCraftingProgress();
            if (this.hasProgressFinished()) {
                this.data.set(3, 1);
                level.setBlock(pos, (BlockState)state.setValue((Property)MobCrusher.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
                this.verifyMobs(level, pos, machineLevel);
                this.extractEnergy();
                MobCrusherBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                this.resetProgress();
            }
            this.data.set(3, 0);
        } else {
            this.data.set(7, 0);
        }
    }

    private boolean hasMobInside(int machinelevel, BlockPos pPos, Level pLevel) {
        ArrayList mobs;
        return !(mobs = new ArrayList(pLevel.getEntitiesOfClass(Mob.class, GetNewAABB.getAABB((BlockPos)pPos.offset(++machinelevel * -1, 0, machinelevel * -1), (BlockPos)pPos.offset(machinelevel, 3, machinelevel))))).isEmpty();
    }

    private void extractEnergy() {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)500, (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public int getMachineLevel() {
        if (ModUtils.isComponent((ItemStack)this.itemHandler.getStackInSlot(13))) {
            this.data.set(5, ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(13)));
        } else {
            this.data.set(5, 0);
        }
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(13));
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.level.hasNeighborSignal(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void setMaxProgress() {
        this.maxProgress = 20;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    private void execute(Mob mob, BlockPos pPos, int machineLevel) {
        IFFakePlayer player = GetFakePlayer.get((ServerLevel)((ServerLevel)this.level));
        player.setItemInHand(InteractionHand.MAIN_HAND, this.itemHandler.getStackInSlot(14));
        ServerPlayer randomPlayer = ((ServerLevel)this.level).getRandomPlayer();
        DamageSource source = player.damageSources().playerAttack((Player)(randomPlayer != null && machineLevel >= 7 ? randomPlayer : player));
        LootTable table = Objects.requireNonNull(this.level.getServer()).reloadableRegistries().getLootTable(mob.getLootTable());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)mob).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ())).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player);
        table.getRandomItems(context.create(LootContextParamSets.ENTITY)).forEach(stack -> {
            this.insertItemOnInventory((ItemStack)stack);
            for (int loot = 0; loot < machineLevel; ++loot) {
                int rand = RandomSource.create().nextInt(10);
                if (rand != 0) continue;
                this.insertItemOnInventory((ItemStack)stack);
            }
        });
        ArrayList extra = new ArrayList();
        if (mob.captureDrops() == null) {
            mob.captureDrops(new ArrayList());
        }
        if (mob.captureDrops() != null) {
            extra.addAll(mob.captureDrops());
        }
        player.attack((Entity)mob);
        extra.forEach(itemEntity -> {
            this.insertItemOnInventory(itemEntity.getItem());
            itemEntity.remove(Entity.RemovalReason.KILLED);
        });
        mob.setHealth(0.0f);
        SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.ELECTRIC_SPARK, (BlockPos)this.worldPosition.above(), (BlockPos)mob.getOnPos().above(2), (double)0.5, (double)0.2, (double)0.5);
        this.insertExpense(mob.getExperienceReward((ServerLevel)this.level, (Entity)player));
    }

    private void insertExpense(int experienceReward) {
        FluidStack fluidStack = new FluidStack((Fluid)ModFluids.EXPERIENCE_SOURCE.get(), experienceReward);
        this.FLUID_STORAGE.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void verifyMobs(Level pLevel, BlockPos pPos, int machinelevel) {
        try {
            ArrayList entities = new ArrayList(pLevel.getEntitiesOfClass(Mob.class, GetNewAABB.getAABB((BlockPos)pPos.offset(++machinelevel * -1, 0, machinelevel * -1), (BlockPos)pPos.offset(machinelevel, 3, machinelevel))));
            this.data.set(4, 0);
            if (!entities.isEmpty()) {
                boolean hasFreeSlots = this.hasFreeSlots();
                if (!hasFreeSlots && entities.size() > 30) {
                    if (this.hasProgressFinished()) {
                        this.insertItemOnInventory(ItemStack.EMPTY);
                    }
                    entities.forEach(Entity::discard);
                    this.notifyOwner();
                } else if (hasFreeSlots) {
                    this.data.set(4, 1);
                    for (Mob entity : entities) {
                        if (entity == null || entity.hasCustomName() || EntityType.getKey((EntityType)entity.getType()).getPath().equalsIgnoreCase("maid") || !entity.isAlive()) continue;
                        this.execute(entity, pPos, machinelevel);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7f[INM\u00a7f]\u00a74: Failed to kill mobs in: " + String.valueOf(pPos));
            e.printStackTrace();
        }
    }

    private void insertItemOnInventory(ItemStack itemStack) {
        try {
            if (this.itemHandler.getStackInSlot(15).is((Item)ModItems.LINKING_TOOL.get())) {
                ItemStack linkingTool = this.itemHandler.getStackInSlot(15).copy();
                AtomicBoolean success = new AtomicBoolean(false);
                String name = linkingTool.getDisplayName().getString();
                this.data.set(8, 0);
                this.data.set(9, 0);
                this.data.set(10, 0);
                if (linkingTool.has((Supplier)CoreDataComponents.LINKINGTOOL_COORDS)) {
                    BlockPos linkingToolPos = (BlockPos)linkingTool.get((Supplier)CoreDataComponents.LINKINGTOOL_COORDS);
                    this.data.set(8, linkingToolPos.getX());
                    this.data.set(9, linkingToolPos.getY());
                    this.data.set(10, linkingToolPos.getZ());
                    int xl = this.data.get(8);
                    int yl = this.data.get(9);
                    int zl = this.data.get(10);
                    BlockEntity blockEntity = this.level.getBlockEntity(new BlockPos(xl, yl, zl));
                    BlockPos targetPos = new BlockPos(xl, yl, zl);
                    if (blockEntity.getBlockPos().equals((Object)this.getBlockPos())) {
                        this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)xl, (double)(yl + 1), (double)zl, this.itemHandler.getStackInSlot(15).copy()));
                        this.itemHandler.extractItem(15, 1, false);
                    }
                    if (!this.itemHandler.getStackInSlot(OUTPUT_SLOT[7]).isEmpty()) {
                        if (blockEntity != null && this.canLink(blockEntity)) {
                            int slot;
                            IItemHandler iItemHandler = ItemStackHandlerUtils.getBlockCapabilityItemHandler((Level)this.level, (BlockPos)targetPos, null);
                            for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                                if (!ModUtils.canPlaceItemInContainer((ItemStack)itemStack.copy(), (int)slot, (IItemHandler)iItemHandler) || !iItemHandler.isItemValid(slot, itemStack.copy())) continue;
                                iItemHandler.insertItem(slot, itemStack.copy(), false);
                                SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.SCRAPE, (BlockPos)this.worldPosition.above(), (BlockPos)targetPos, (double)0.5, (double)0.2, (double)0.5);
                                success.set(true);
                                break;
                            }
                            block3: for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                                for (int outputSlot : OUTPUT_SLOT) {
                                    if (this.itemHandler.getStackInSlot(outputSlot).isEmpty() || !iItemHandler.isItemValid(slot, itemStack.copy()) || !ModUtils.canPlaceItemInContainer((ItemStack)this.itemHandler.getStackInSlot(outputSlot).copy(), (int)slot, (IItemHandler)iItemHandler)) continue;
                                    iItemHandler.insertItem(slot, this.itemHandler.getStackInSlot(outputSlot).copy(), false);
                                    this.itemHandler.extractItem(outputSlot, this.itemHandler.getStackInSlot(outputSlot).getCount(), false);
                                    success.set(true);
                                    continue block3;
                                }
                            }
                        } else {
                            ModUtils.ejectItemsWhePusher((BlockPos)this.worldPosition.above(), (int[])UPGRADE_SLOTS, (int[])OUTPUT_SLOT, (ItemStackHandler)this.itemHandler, (Level)this.level);
                        }
                    }
                }
                if (!success.get()) {
                    this.insertItemOnSelfInventory(itemStack);
                }
            } else {
                this.insertItemOnSelfInventory(itemStack);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7f[INM\u00a7f]\u00a7c: Failed to insert item in: " + String.valueOf(this.getBlockPos()));
        }
    }

    private void insertItemOnSelfInventory(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        for (int slot : OUTPUT_SLOT) {
            ItemStack existingStack = this.itemHandler.getStackInSlot(slot);
            if (existingStack.isEmpty() || !ItemStack.isSameItem((ItemStack)existingStack, (ItemStack)itemStack) || existingStack.getItem() != itemStack.getItem() || existingStack.getCount() >= existingStack.getMaxStackSize()) continue;
            int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
            int amountToAdd = Math.min(spaceAvailable, itemStack.getCount());
            existingStack.grow(amountToAdd);
            itemStack.shrink(amountToAdd);
            if (!itemStack.isEmpty()) continue;
            return;
        }
        for (int slot : OUTPUT_SLOT) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            this.itemHandler.insertItem(slot, itemStack.copy(), false);
            return;
        }
    }

    private boolean canLink(BlockEntity blockEntity) {
        return (int)Math.sqrt(this.getBlockPos().distSqr((Vec3i)blockEntity.getBlockPos())) < 100;
    }

    public String getHasLink() {
        if (this.data.get(8) != 0 || this.data.get(9) != 0 || this.data.get(10) != 0) {
            return "X: " + this.data.get(8) + ", Y: " + this.data.get(9) + ", Z: " + this.data.get(10);
        }
        return "[Unlinked]";
    }

    public ItemStack getLikedBlock() {
        return new ItemStack((ItemLike)this.level.getBlockState(new BlockPos(this.data.get(8), this.data.get(9), this.data.get(10))).getBlock().asItem());
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)13, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }

    public void setShowArea(boolean show) {
        this.showArea = show;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean shouldShowArea() {
        return this.showArea;
    }

    private void renderAreaPreview(Level level, BlockPos pos) {
        if (!this.showArea || !level.isClientSide()) {
            return;
        }
        int machineLevel = this.getMachineLevel();
        if (machineLevel <= 0) {
            return;
        }
        int range = machineLevel;
        BlockPos start = pos.above();
        this.renderCubeEdges(level, start, range);
    }

    private void renderCubeEdges(Level level, BlockPos start, int range) {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    if (!this.isEdgePosition(x, y, z, range)) continue;
                    this.spawnEdgeParticle(level, start, x, y, z);
                }
            }
        }
    }

    private void spawnEdgeParticle(Level level, BlockPos start, int x, int y, int z) {
        if (level.random.nextFloat() < 0.5f) {
            double particleX = (double)(start.getX() + x) + 0.5;
            double particleY = start.getY() + y;
            double particleZ = (double)(start.getZ() + z) + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, particleX, particleY, particleZ, 0.0, 0.01, 0.0);
        }
    }

    private boolean isEdgePosition(int x, int y, int z, int range) {
        if (Math.abs(x) == range && Math.abs(z) == range) {
            return true;
        }
        if (y == 0 || y == 2) {
            return Math.abs(x) == range || Math.abs(z) == range;
        }
        return false;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            return;
        }
        if (this.showArea) {
            this.renderAreaPreview(level, pos);
        }
    }

    private boolean hasFreeSlots() {
        for (int slot : OUTPUT_SLOT) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void notifyOwner() {
    }

    private void verifySolidFuel() {
        ItemStack slotItem = this.itemHandler.getStackInSlot(16);
        int burnTime = slotItem.getBurnTime(null);
        if (burnTime > 1) {
            while (this.itemHandler.getStackInSlot(16).getCount() > 0 && this.getEnergyStorage().getEnergyStored() + burnTime < this.getEnergyStorage().getMaxEnergyStored()) {
                this.getEnergyStorage().receiveEnergy(burnTime, false);
                this.itemHandler.extractItem(16, 1, false);
            }
        }
    }

    private void handleLinkedInsertion(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        BlockEntity targetEntity = this.level.getBlockEntity(new BlockPos(this.data.get(8), this.data.get(9), this.data.get(10)));
        if (targetEntity == null) {
            return;
        }
        IItemHandler itemHandler = ItemStackHandlerUtils.getBlockCapabilityItemHandler((Level)this.level, (BlockPos)targetEntity.getBlockPos(), null);
        if (itemHandler == null) {
            return;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.isItemValid(slot, stack)) continue;
            ItemStack remaining = itemHandler.insertItem(slot, stack.copy(), false);
            stack.setCount(remaining.getCount());
            if (stack.isEmpty()) break;
        }
    }
}

