/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Core.utils.ProgressUtils;
import com.Infinity.Nexus.Core.utils.SoundUtils;
import com.Infinity.Nexus.Mod.block.custom.Smeltery;
import com.Infinity.Nexus.Mod.block.entity.BaseMenuProviderBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.Infinity.Nexus.Mod.recipe.SmelteryRecipes;
import com.Infinity.Nexus.Mod.screen.smeltery.SmelteryMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmelteryBlockEntity
extends BaseMenuProviderBlockEntity {
    private static final int ENERGY_REQ = 32;
    private final RestrictedItemStackHandler itemHandler = new RestrictedItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SmelteryBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> false;
                case 4, 5, 6, 7 -> ModUtils.isUpgrade((ItemStack)stack);
                case 8 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };

    public SmelteryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.SMELTERY_BE.get(), pPos, pBlockState, (Component)Component.translatable((String)"block.infinity_nexus_mod.smeltery"), new int[]{0, 1, 2}, 3, new int[]{4, 5, 6, 7}, 8, ConfigUtils.smelter_energy_storage_capacity, ConfigUtils.smelter_energy_transfer_rate);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("smeltery.progress", this.progress);
        pTag.putInt("smeltery.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("smeltery.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("smeltery.energy"));
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.infinity_nexus_mod.smeltery").append(" LV " + this.getMachineLevel());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SmelteryMenu(pContainerId, pPlayerInventory, this, this.data, this.itemHandler);
    }

    public void drops() {
        this.dropContents(this.level, this.worldPosition, (ItemStackHandler)this.itemHandler);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide) {
            return;
        }
        int machineLevel = Math.max(this.getMachineLevel() - 1, 0);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Smeltery.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.itemHandler.getStackInSlot(this.COMPONENT_SLOT).isEmpty()) {
            return;
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        Optional<RecipeHolder<SmelteryRecipes>> recipe = this.getCurrentRecipe();
        if (!this.hasRecipe(recipe)) {
            this.resetProgress();
            return;
        }
        this.maxProgress = ProgressUtils.setMaxProgress((int)machineLevel, (int)((SmelteryRecipes)recipe.get().value()).getDuration(), (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS, (int)ConfigUtils.smelter_minimum_tick);
        this.data.set(1, this.maxProgress);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)Smeltery.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractRecipeEnergy(recipe);
        SmelteryBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.above(), (int[])this.UPGRADE_SLOTS, (int[])new int[]{this.OUTPUT_SLOT}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractRecipeEnergy(Optional<RecipeHolder<SmelteryRecipes>> recipe) {
        EnergyUtils.extractEnergyFromRecipe((IEnergyStorage)this.ENERGY_STORAGE, (int)((SmelteryRecipes)recipe.get().value()).getEnergy(), (int)(this.getMachineLevel() + 1), (int)this.maxProgress, (ItemStackHandler)this.itemHandler, (int[])this.UPGRADE_SLOTS);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void craftItem() {
        Optional<RecipeHolder<SmelteryRecipes>> recipe = this.getCurrentRecipe();
        ItemStack result = ((SmelteryRecipes)recipe.get().value()).getResultItem(null);
        for (int i = 1; i < ((SmelteryRecipes)recipe.get().value()).getIngredients().size(); ++i) {
            int slotIndex = this.INPUT_SLOT[i - 1];
            ItemStackHandlerUtils.extractItem((int)slotIndex, (int)((SmelteryRecipes)recipe.get().value()).getInputCount(i), (boolean)false, (RestrictedItemStackHandler)this.itemHandler);
        }
        ItemStack component = this.itemHandler.getStackInSlot(this.COMPONENT_SLOT);
        ModUtils.useComponent((ItemStack)component, (Level)this.level, (BlockPos)this.getBlockPos());
        result.setCount(this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).getCount() + result.getCount());
        ItemStackHandlerUtils.setStackInSlot((int)this.OUTPUT_SLOT, (ItemStack)result, (RestrictedItemStackHandler)this.itemHandler);
        SoundUtils.playSound((Level)this.level, (BlockPos)this.worldPosition, (SoundSource)SoundSource.BLOCKS, (SoundEvent)SoundEvents.LAVA_EXTINGUISH, (float)0.3f, (float)1.0f);
    }

    private boolean hasRecipe(Optional<RecipeHolder<SmelteryRecipes>> recipe) {
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((SmelteryRecipes)recipe.get().value()).getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        return ItemStackHandlerUtils.canInsertItemAndAmountIntoOutputSlot((Item)result.getItem(), (int)result.getCount(), (int)this.OUTPUT_SLOT, (RestrictedItemStackHandler)this.itemHandler);
    }

    private Optional<RecipeHolder<SmelteryRecipes>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        inventory.setItem(0, this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
        inventory.setItem(1, this.itemHandler.getStackInSlot(0));
        inventory.setItem(2, this.itemHandler.getStackInSlot(1));
        inventory.setItem(3, this.itemHandler.getStackInSlot(2));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SMELTRERY_RECIPE_TYPE.get(), (RecipeInput)new MultipleMachinesRecipeInput(inventory, 4), this.level);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(this.COMPONENT_SLOT));
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)this.COMPONENT_SLOT, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])this.UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

