/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.EnergyUtils;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.custom.TranslocatorEnergy;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TranslocatorEnergyBlockEntity
extends TranslocatorBlockEntityBase {
    private static final int CAPACITY = 1240000;
    private static final int MAX_TRANSFER = 512000;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public TranslocatorEnergyBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.TRASLOCATOR_ENERGY_BE.get(), pPos, pBlockState);
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(1240000, 512000){

            public void onEnergyChanged() {
                TranslocatorEnergyBlockEntity.this.setChanged();
                TranslocatorEnergyBlockEntity.this.getLevel().sendBlockUpdated(TranslocatorEnergyBlockEntity.this.getBlockPos(), TranslocatorEnergyBlockEntity.this.getBlockState(), TranslocatorEnergyBlockEntity.this.getBlockState(), 4);
            }
        };
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        pTag.putInt("translocator.progress", this.progress);
        pTag.putInt("translocator.max_progress", this.maxProgress);
        pTag.putInt("translocator.mode", this.mode);
        pTag.putInt("translocator.step", this.step);
        pTag.putString("translocator.filter", this.filter == null ? "" : String.join((CharSequence)";", this.filter));
        pTag.putInt("translocator.filterIndex", this.filterIndex);
        pTag.putInt("translocator.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, registries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        this.itemHandler.deserializeNBT(registries, pTag.getCompound("inventory"));
        this.progress = pTag.getInt("translocator.progress");
        this.maxProgress = pTag.getInt("translocator.max_progress");
        this.mode = pTag.getInt("translocator.mode");
        this.step = pTag.getInt("translocator.step");
        this.filter = pTag.getString("translocator.filter").isEmpty() ? new String[]{} : pTag.getString("translocator.filter").split(";");
        this.filterIndex = pTag.getInt("translocator.filterIndex");
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("translocator.energy"));
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (this.mode == 0) {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.depositEnergy(pLevel, pPos);
            } else {
                this.increaseProgress();
            }
        } else if (this.canSend()) {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.sendEnergy(pLevel);
                this.upgradeStep();
            }
            this.increaseProgress();
        } else {
            if (this.hasProgressFinished()) {
                this.resetProgress();
                this.pullEnergy(pLevel, pPos, pState);
            }
            this.increaseProgress();
        }
        this.updateLit(pLevel, pState);
        TranslocatorEnergyBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    @Override
    protected boolean canSend() {
        return this.ENERGY_STORAGE.getEnergyStored() > 0 && !this.itemHandler.getStackInSlot(1).isEmpty();
    }

    private void pullEnergy(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, pState);
        if (entity == null) {
            return;
        }
        IEnergyStorage sourceHandler = EnergyUtils.getBlockCapabilityEnergyHandler((Level)pLevel, (BlockPos)entity.getBlockPos(), (Direction)((Direction)this.getBlockState().getValue((Property)TranslocatorEnergy.FACING)).getOpposite());
        if (sourceHandler == null) {
            return;
        }
        EnergyUtils.transferEnergy((IEnergyStorage)sourceHandler, (IEnergyStorage)this.ENERGY_STORAGE, (int)512000);
    }

    private void sendEnergy(Level pLevel) {
        BlockPos targetPos = this.getDestination();
        BlockEntity entity = pLevel.getBlockEntity(targetPos);
        if (entity == null) {
            return;
        }
        IEnergyStorage targetHandler = EnergyUtils.getBlockCapabilityEnergyHandler((Level)pLevel, (BlockPos)entity.getBlockPos(), null);
        if (targetHandler == null) {
            return;
        }
        SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.ELECTRIC_SPARK, (BlockPos)this.worldPosition, (BlockPos)entity.getBlockPos(), (double)0.5, (double)0.5, (double)0.5);
        if (entity instanceof TranslocatorEnergyBlockEntity) {
            TranslocatorEnergyBlockEntity translocator = (TranslocatorEnergyBlockEntity)entity;
            translocator.receiveEnergy(this.ENERGY_STORAGE);
            return;
        }
        EnergyUtils.transferEnergy((IEnergyStorage)this.ENERGY_STORAGE, (IEnergyStorage)targetHandler, (int)512000);
    }

    private void receiveEnergy(ModEnergyStorage energyStorage) {
        EnergyUtils.transferEnergy((IEnergyStorage)energyStorage, (IEnergyStorage)this.ENERGY_STORAGE, (int)512000);
        this.progress = this.maxProgress - ConfigUtils.translocator_skip_progress;
    }

    private void depositEnergy(Level pLevel, BlockPos pPos) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, this.getBlockState());
        if (entity == null) {
            return;
        }
        IEnergyStorage targetHandler = EnergyUtils.getBlockCapabilityEnergyHandler((Level)pLevel, (BlockPos)entity.getBlockPos(), (Direction)((Direction)this.getBlockState().getValue((Property)TranslocatorEnergy.FACING)).getOpposite());
        if (targetHandler == null) {
            return;
        }
        EnergyUtils.transferEnergy((IEnergyStorage)this.ENERGY_STORAGE, (IEnergyStorage)targetHandler, (int)512000);
    }

    public IEnergyStorage getEnergyStorage(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    @Override
    protected void updateLit(Level level, BlockState state) {
        int lit = 6;
        int step = this.maxProgress / 5;
        if (this.mode == 1) {
            if (this.canSend()) {
                lit = this.progress >= 4 * step ? 5 : (this.progress >= 3 * step ? 4 : (this.progress >= 2 * step ? 3 : (this.progress >= step ? 2 : 1)));
            }
        } else if (this.mode == 0 && this.canSend()) {
            lit = this.progress <= step ? 5 : (this.progress <= 2 * step ? 4 : (this.progress <= 3 * step ? 3 : (this.progress <= 4 * step ? 2 : 1)));
        }
        this.setLit(level, state, lit);
    }
}

