/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.utils.ItemStackHandlerUtils;
import com.Infinity.Nexus.Core.utils.SendParticlesPath;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class TranslocatorItemBlockEntity
extends TranslocatorBlockEntityBase {
    public TranslocatorItemBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.TRASLOCATOR_ITEM_BE.get(), pPos, pBlockState);
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (this.mode == 0 && !this.isInputSlotEmpty()) {
            if (this.hasProgressFinished()) {
                this.depositItem(pLevel, pPos);
            } else {
                this.increaseProgress();
            }
        } else if (this.canSend()) {
            if (!this.isInputSlotEmpty()) {
                if (this.hasProgressFinished()) {
                    this.resetProgress();
                    this.sendItem(pLevel);
                    this.upgradeStep();
                }
                this.increaseProgress();
            } else {
                if (this.hasProgressFinished() && this.isInputSlotEmpty()) {
                    this.resetProgress();
                    this.pullItem(pLevel, pPos, pState);
                }
                this.increaseProgress();
            }
        }
        this.updateLit(pLevel, pState);
        TranslocatorItemBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void pullItem(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, pState);
        if (entity == null) {
            return;
        }
        IItemHandler sourceHandler = ItemStackHandlerUtils.getBlockCapabilityItemHandler((Level)pLevel, (BlockPos)entity.getBlockPos(), (Direction)Direction.UP);
        if (sourceHandler == null) {
            return;
        }
        if (this.filter != null && this.filter.length > 0) {
            boolean itemPulled = false;
            int startIdx = this.filterIndex;
            for (int i = 0; i < this.filter.length; ++i) {
                int currentIdx = (startIdx + i) % this.filter.length;
                String targetItem = this.filter[currentIdx];
                for (int slot = 0; slot < sourceHandler.getSlots(); ++slot) {
                    int amountToPull;
                    ItemStack extracted;
                    int spaceAvailable;
                    String itemId;
                    ItemStack stackInSlot = sourceHandler.getStackInSlot(slot);
                    if (stackInSlot.isEmpty() || !(itemId = stackInSlot.getItem().builtInRegistryHolder().key().location().toString()).equals(targetItem)) continue;
                    ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                    int maxStackSize = Math.min(stackInSlot.getMaxStackSize(), this.itemHandler.getSlotLimit(0));
                    if (currentStack.isEmpty()) {
                        int amountToPull2 = Math.min(stackInSlot.getCount(), maxStackSize);
                        ItemStack extracted2 = sourceHandler.extractItem(slot, amountToPull2, false);
                        if (!extracted2.isEmpty()) {
                            this.itemHandler.setStackInSlot(0, extracted2);
                            this.resetProgress();
                            itemPulled = true;
                            this.filterIndex = (currentIdx + 1) % this.filter.length;
                            this.setChanged();
                            break;
                        }
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)stackInSlot) && (spaceAvailable = maxStackSize - currentStack.getCount()) > 0 && !(extracted = sourceHandler.extractItem(slot, amountToPull = Math.min(stackInSlot.getCount(), spaceAvailable), false)).isEmpty()) {
                        currentStack.grow(extracted.getCount());
                        this.itemHandler.setStackInSlot(0, currentStack);
                        this.resetProgress();
                        itemPulled = true;
                        this.filterIndex = (currentIdx + 1) % this.filter.length;
                        this.setChanged();
                        break;
                    }
                    if (itemPulled) break;
                }
                if (!itemPulled) {
                    continue;
                }
                break;
            }
        } else {
            for (int slot = 0; slot < sourceHandler.getSlots(); ++slot) {
                ItemStack stackInSlot = sourceHandler.getStackInSlot(slot);
                if (stackInSlot.isEmpty()) continue;
                ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                int maxStackSize = Math.min(stackInSlot.getMaxStackSize(), this.itemHandler.getSlotLimit(0));
                if (currentStack.isEmpty()) {
                    int amountToPull = Math.min(stackInSlot.getCount(), maxStackSize);
                    ItemStack extracted = sourceHandler.extractItem(slot, amountToPull, false);
                    if (extracted.isEmpty()) continue;
                    this.itemHandler.setStackInSlot(0, extracted);
                    this.resetProgress();
                } else {
                    int amountToPull;
                    ItemStack extracted;
                    int spaceAvailable;
                    if (!ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)stackInSlot) || (spaceAvailable = maxStackSize - currentStack.getCount()) <= 0 || (extracted = sourceHandler.extractItem(slot, amountToPull = Math.min(stackInSlot.getCount(), spaceAvailable), false)).isEmpty()) continue;
                    currentStack.grow(extracted.getCount());
                    this.itemHandler.setStackInSlot(0, currentStack);
                    this.resetProgress();
                }
                break;
            }
        }
    }

    private void depositItem(Level level, BlockPos pos) {
        BlockEntity entity = this.getInventoryPos(level, pos, this.getBlockState());
        if (entity == null) {
            return;
        }
        IItemHandler targetHandler = ItemStackHandlerUtils.getBlockCapabilityItemHandler((Level)level, (BlockPos)entity.getBlockPos(), (Direction)Direction.DOWN);
        if (targetHandler == null) {
            return;
        }
        ItemStack stackToDeposit = this.itemHandler.getStackInSlot(0);
        if (stackToDeposit.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < targetHandler.getSlots(); ++slot) {
            ItemStack remaining = targetHandler.insertItem(slot, stackToDeposit, false);
            if (remaining.getCount() == stackToDeposit.getCount()) continue;
            this.itemHandler.setStackInSlot(0, remaining);
            this.resetProgress();
            if (remaining.isEmpty()) break;
        }
    }

    private void sendItem(Level level) {
        BlockPos targetPos = this.getDestination();
        BlockEntity entity = level.getBlockEntity(targetPos);
        if (entity instanceof TranslocatorItemBlockEntity) {
            TranslocatorItemBlockEntity translocator = (TranslocatorItemBlockEntity)entity;
            ItemStack stackToSend = this.itemHandler.getStackInSlot(0);
            if (stackToSend != null && !stackToSend.isEmpty()) {
                if (translocator.receiveItem(stackToSend)) {
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                    SendParticlesPath.makePath((ServerLevel)((ServerLevel)this.getLevel()), (SimpleParticleType)ParticleTypes.CRIT, (BlockPos)this.worldPosition, (BlockPos)targetPos, (double)0.5, (double)0.5, (double)0.5);
                } else {
                    this.progress = this.maxProgress - 5;
                }
            }
        }
    }

    public boolean receiveItem(ItemStack stack) {
        if (stack.isEmpty() || !this.isInputSlotEmpty() || !this.isFiltered(stack)) {
            return false;
        }
        ItemStack currentStack = this.itemHandler.getStackInSlot(0);
        if (currentStack.isEmpty()) {
            int stackLimit = Math.min(stack.getMaxStackSize(), this.itemHandler.getSlotLimit(0));
            ItemStack toInsert = stack.copy();
            toInsert.setCount(Math.min(toInsert.getCount(), stackLimit));
            this.itemHandler.setStackInSlot(0, toInsert);
        } else if (currentStack == stack) {
            int maxStackSize = Math.min(currentStack.getMaxStackSize(), this.itemHandler.getSlotLimit(0));
            int newCount = currentStack.getCount() + stack.getCount();
            if (newCount <= maxStackSize) {
                currentStack.grow(stack.getCount());
            } else {
                int remaining = maxStackSize - currentStack.getCount();
                currentStack.grow(remaining);
            }
            this.itemHandler.setStackInSlot(0, currentStack);
        } else {
            return false;
        }
        if (this.canSend()) {
            this.progress = ConfigUtils.translocator_skip_progress;
        }
        this.setChanged();
        return true;
    }
}

