/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity.renderer;

import com.Infinity.Nexus.Mod.block.custom.Factory;
import com.Infinity.Nexus.Mod.block.entity.FactoryBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class FactoryBlockEntityRenderer
implements BlockEntityRenderer<FactoryBlockEntity> {
    float[] x = new float[]{1.032f, 0.782f, 0.5f, 0.218f, -0.032f, 1.032f, -0.04f, 1.032f, -0.04f, 1.032f, -0.04f, 1.032f, 0.782f, 0.5f, 0.218f, -0.032f};
    float[] y = new float[]{1.175f, 1.145f, 1.115f, 1.145f, 1.175f, 1.145f, 1.145f, 1.115f, 1.115f, 1.145f, 1.145f, 1.175f, 1.145f, 1.115f, 1.145f, 1.175f};
    float[] z = new float[]{1.032f, 1.032f, 1.032f, 1.032f, 1.032f, 0.782f, 0.782f, 0.5f, 0.5f, 0.218f, 0.218f, -0.032f, -0.032f, -0.032f, -0.032f, -0.032f};

    public FactoryBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FactoryBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        int maxProgress = pBlockEntity.getMaxProgress();
        int progress = pBlockEntity.getCurrentProgress();
        for (int i = 0; i < 16; ++i) {
            if (pBlockEntity.getRenderStack(i) == ItemStack.EMPTY) continue;
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            if (progress > 0 && maxProgress > 0) {
                float x = this.x[i] - (this.x[i] - 0.5f) * ((float)progress / (float)maxProgress);
                float y = this.y[i] - (this.y[i] - 1.032f) * ((float)progress / (float)maxProgress);
                float z = this.z[i] - (this.z[i] - 0.5f) * ((float)progress / (float)maxProgress);
                ItemStack itemStack = pBlockEntity.getRenderStack(i);
                pPoseStack.pushPose();
                pPoseStack.translate(x, y, z);
                pPoseStack.scale(0.1f, 0.1f, 0.1f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(360.0f * ((float)progress / (float)maxProgress)));
                itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, this.getLightLevel(pBlockEntity.getLevel(), pBlockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
                pPoseStack.popPose();
                continue;
            }
            ItemStack itemStack = pBlockEntity.getRenderStack(i);
            pPoseStack.pushPose();
            pPoseStack.translate(this.x[i], this.y[i], this.z[i]);
            pPoseStack.scale(0.1f, 0.1f, 0.1f);
            pPoseStack.mulPose(Axis.YN.rotationDegrees(((Direction)pBlockEntity.getBlockState().getValue((Property)Factory.FACING)).toYRot()));
            itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, this.getLightLevel(pBlockEntity.getLevel(), pBlockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
            pPoseStack.popPose();
        }
    }

    private int getLightLevel(Level pLevel, BlockPos pPos) {
        int blight = pLevel.getBrightness(LightLayer.BLOCK, pPos);
        int slight = pLevel.getBrightness(LightLayer.SKY, pPos);
        return LightTexture.pack((int)blight, (int)slight);
    }
}

