/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.entity.ai;

import com.Infinity.Nexus.Mod.entity.custom.Asgreon;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class AsgreonAttackGoal
extends MeleeAttackGoal {
    private final Asgreon entity;
    private int attackDelay = 50;
    private int tickUntilNextAttack = 80;
    private boolean shouldCountTillNextAttack = false;

    public AsgreonAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (Asgreon)pMob;
    }

    protected void checkAndPerformAttack(LivingEntity pEnemy) {
        if (this.isEnemyWithinAttackDistance(pEnemy, 5.0)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttacAnimation()) {
                this.entity.setAttacking(true);
            }
            if (this.isTimeToAttack()) {
                this.mob.getLookControl().setLookAt(pEnemy.getX(), pEnemy.getY(), pEnemy.getZ());
                this.performAttack(pEnemy);
            }
        } else {
            this.resetAttackCooldown();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= 5.0;
    }

    protected void resetAttackCooldown() {
        this.tickUntilNextAttack = this.adjustedTickDelay(this.attackDelay * 2);
    }

    public boolean isTimeToAttack() {
        return this.tickUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.tickUntilNextAttack;
    }

    private void performAttack(LivingEntity pEnemy) {
        this.resetAttackCooldown();
        this.mob.swing(InteractionHand.MAIN_HAND);
        this.mob.doHurtTarget((Entity)pEnemy);
    }

    private boolean isTimeToStartAttacAnimation() {
        return this.tickUntilNextAttack <= this.attackDelay;
    }

    public void start() {
        super.start();
        this.attackDelay = 50;
        this.tickUntilNextAttack = 80;
    }

    public void tick() {
        super.tick();
        if (this.shouldCountTillNextAttack) {
            this.tickUntilNextAttack = Math.max(this.tickUntilNextAttack - 1, 0);
        }
    }

    public void stop() {
        this.entity.setAttacking(false);
        super.stop();
    }
}

