/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.entity.client;

import com.Infinity.Nexus.Mod.entity.animations.ModAnimmationDefinitions;
import com.Infinity.Nexus.Mod.entity.custom.Asgreon;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AsgreonModel<T extends Asgreon>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"modid", (String)"asgreon-vanilla"), "main");
    private final ModelPart asgreon;
    private final ModelPart head;
    private final ModelPart body;

    public AsgreonModel(ModelPart root) {
        this.asgreon = root.getChild("asgreon");
        this.head = this.asgreon.getChild("body").getChild("torso").getChild("head");
        this.body = this.asgreon.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rhino = partdefinition.addOrReplaceChild("asgreon", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = rhino.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(13, 52).addBox(-3.0f, -1.5f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)0.5f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.5f, (float)-0.5f));
        PartDefinition skull = head.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(72, 31).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_ear = skull.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, 0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -3.0f, -1.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -3.0f, -3.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -3.0f, 2.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)-0.5f));
        PartDefinition right_ear = skull.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, -3.0f, 0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-2.0f, -3.0f, -1.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-2.0f, -3.0f, -3.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-2.0f, -3.0f, 2.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)-3.0f, (float)-0.5f));
        PartDefinition left_eye = skull.addOrReplaceChild("left_eye", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.8f, (float)10.1f, (float)-32.9f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = left_eye.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(57, 46).addBox(5.2052f, -2.6833f, 2.198f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.8f, (float)-0.2748f, (float)34.1342f, (float)-1.309f, (float)1.309f, (float)-1.5708f));
        PartDefinition light2 = left_eye.addOrReplaceChild("light2", CubeListBuilder.create(), PartPose.offset((float)-3.2552f, (float)-3.4192f, (float)28.9667f));
        PartDefinition cube_r2 = light2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(55, 46).addBox(5.3052f, -1.4833f, 2.398f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5448f, (float)3.1445f, (float)5.1675f, (float)-1.309f, (float)1.309f, (float)-1.5708f));
        PartDefinition left_eyelid = skull.addOrReplaceChild("left_eyelid", CubeListBuilder.create(), PartPose.offset((float)5.05f, (float)10.1f, (float)-32.9f));
        PartDefinition cube_r3 = left_eyelid.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(42, 85).addBox(4.4552f, -4.0f, 1.3052f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.05f, (float)-9.1f, (float)32.9f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition right_eyelid = skull.addOrReplaceChild("right_eyelid", CubeListBuilder.create(), PartPose.offset((float)-5.05f, (float)10.1f, (float)-32.9f));
        PartDefinition cube_r4 = right_eyelid.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(42, 85).mirror().addBox(-5.4552f, -4.0f, 1.3052f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.05f, (float)-9.1f, (float)32.9f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition right_eye = skull.addOrReplaceChild("right_eye", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-5.8f, (float)10.1f, (float)-32.9f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = right_eye.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(57, 46).mirror().addBox(-6.2052f, -2.6833f, 2.198f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.8f, (float)-0.2748f, (float)34.1342f, (float)-1.309f, (float)-1.309f, (float)1.5708f));
        PartDefinition light = right_eye.addOrReplaceChild("light", CubeListBuilder.create(), PartPose.offset((float)3.2552f, (float)-3.4192f, (float)28.9667f));
        PartDefinition cube_r6 = light.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(55, 46).mirror().addBox(-6.3052f, -1.4833f, 2.398f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.5448f, (float)3.1445f, (float)5.1675f, (float)-1.309f, (float)-1.309f, (float)1.5708f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-15.5f, (float)24.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        PartDefinition left_back_leg = body.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition hexadecagon_r1 = left_back_leg.addOrReplaceChild("hexadecagon_r1", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r2 = left_back_leg.addOrReplaceChild("hexadecagon_r2", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r3 = left_back_leg.addOrReplaceChild("hexadecagon_r3", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r4 = left_back_leg.addOrReplaceChild("hexadecagon_r4", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r5 = left_back_leg.addOrReplaceChild("hexadecagon_r5", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r6 = left_back_leg.addOrReplaceChild("hexadecagon_r6", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r7 = left_back_leg.addOrReplaceChild("hexadecagon_r7", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r8 = left_back_leg.addOrReplaceChild("hexadecagon_r8", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r9 = left_back_leg.addOrReplaceChild("hexadecagon_r9", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_back_knee = left_back_leg.addOrReplaceChild("left_back_knee", CubeListBuilder.create(), PartPose.offset((float)5.5f, (float)4.0f, (float)34.0f));
        PartDefinition left_back_heel = left_back_knee.addOrReplaceChild("left_back_heel", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)-0.5f));
        PartDefinition right_back_leg = body.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition hexadecagon_r10 = right_back_leg.addOrReplaceChild("hexadecagon_r10", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r11 = right_back_leg.addOrReplaceChild("hexadecagon_r11", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r12 = right_back_leg.addOrReplaceChild("hexadecagon_r12", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r13 = right_back_leg.addOrReplaceChild("hexadecagon_r13", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r14 = right_back_leg.addOrReplaceChild("hexadecagon_r14", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r15 = right_back_leg.addOrReplaceChild("hexadecagon_r15", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r16 = right_back_leg.addOrReplaceChild("hexadecagon_r16", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r17 = right_back_leg.addOrReplaceChild("hexadecagon_r17", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r18 = right_back_leg.addOrReplaceChild("hexadecagon_r18", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_back_knee = right_back_leg.addOrReplaceChild("right_back_knee", CubeListBuilder.create(), PartPose.offset((float)-1.5104f, (float)-2.0104f, (float)-3.0f));
        PartDefinition right_front_leg = body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition hexadecagon_r19 = right_front_leg.addOrReplaceChild("hexadecagon_r19", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r20 = right_front_leg.addOrReplaceChild("hexadecagon_r20", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r21 = right_front_leg.addOrReplaceChild("hexadecagon_r21", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r22 = right_front_leg.addOrReplaceChild("hexadecagon_r22", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r23 = right_front_leg.addOrReplaceChild("hexadecagon_r23", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r24 = right_front_leg.addOrReplaceChild("hexadecagon_r24", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r25 = right_front_leg.addOrReplaceChild("hexadecagon_r25", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r26 = right_front_leg.addOrReplaceChild("hexadecagon_r26", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r27 = right_front_leg.addOrReplaceChild("hexadecagon_r27", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_knee = right_front_leg.addOrReplaceChild("right_front_knee", CubeListBuilder.create(), PartPose.offset((float)-8.5f, (float)14.0f, (float)-23.5f));
        PartDefinition left_front_leg = body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition hexadecagon_r28 = left_front_leg.addOrReplaceChild("hexadecagon_r28", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r29 = left_front_leg.addOrReplaceChild("hexadecagon_r29", CubeListBuilder.create().texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r30 = left_front_leg.addOrReplaceChild("hexadecagon_r30", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r31 = left_front_leg.addOrReplaceChild("hexadecagon_r31", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r32 = left_front_leg.addOrReplaceChild("hexadecagon_r32", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5109f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r33 = left_front_leg.addOrReplaceChild("hexadecagon_r33", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r34 = left_front_leg.addOrReplaceChild("hexadecagon_r34", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(25, 2).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r35 = left_front_leg.addOrReplaceChild("hexadecagon_r35", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition hexadecagon_r36 = left_front_leg.addOrReplaceChild("hexadecagon_r36", CubeListBuilder.create().texOffs(42, 19).addBox(-0.5f, -0.5f, -10.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_knee = left_front_leg.addOrReplaceChild("left_front_knee", CubeListBuilder.create(), PartPose.offset((float)5.5f, (float)14.0f, (float)-23.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Asgreon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!entity.isSitting()) {
            this.applyHeadRotation(entity, netHeadYaw, headPitch, ageInTicks);
        }
        if (entity.isWalking()) {
            System.out.println("WALK");
            this.animateWalk(ModAnimmationDefinitions.ASGREON_WALK, limbSwing, limbSwingAmount, 1.2f, 2.0f);
        }
        this.animate(entity.idleAnimationState, ModAnimmationDefinitions.ASGREON_IDLE, ageInTicks, 1.0f);
        this.animate(entity.attackAnimationState, ModAnimmationDefinitions.ASGREON_ATTACK, ageInTicks, 2.0f);
        this.animate(entity.sitAnimationState, ModAnimmationDefinitions.ASGREON_SIT, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(Asgreon entity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-45.0f, (float)45.0f);
        this.body.xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.asgreon.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.asgreon;
    }
}

