/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.events;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="infinity_nexus_mod")
public class PlayerDamageEvent {
    private static final int BOOTS_SLOT = 0;
    private static final int LEGGINGS_SLOT = 1;
    private static final int CHESTPLATE_SLOT = 2;
    private static final int HELMET_SLOT = 3;

    @SubscribeEvent
    public static void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        try {
            PlayerDamageEvent.handlePlayerArmorEffects(event, player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handlePlayerArmorEffects(LivingIncomingDamageEvent event, Player player) {
        if (PlayerDamageEvent.handleImperialArmor(event, player)) {
            return;
        }
        if (PlayerDamageEvent.handleCarbonArmor(event, player)) {
            return;
        }
    }

    private static boolean handleImperialArmor(LivingIncomingDamageEvent event, Player player) {
        if (!PlayerDamageEvent.hasFullImperialArmor(player)) {
            return false;
        }
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof Player) {
            Player enemy = (Player)attacker;
            PlayerDamageEvent.handlePlayerAttacker(event, enemy);
            return true;
        }
        if (attacker instanceof Mob) {
            Mob mob = (Mob)attacker;
            PlayerDamageEvent.handleMobAttacker(event, player, mob);
        }
        event.setCanceled(true);
        return true;
    }

    private static void handlePlayerAttacker(LivingIncomingDamageEvent event, Player enemy) {
        ItemStack weapon = enemy.getMainHandItem();
        if (!PlayerDamageEvent.isCorrectWeapon(weapon)) {
            PlayerDamageEvent.sendInvalidWeaponMessage(enemy);
            event.setCanceled(true);
            return;
        }
        PlayerDamageEvent.applyImperialDamageReduction(event);
    }

    private static void sendInvalidWeaponMessage(Player enemy) {
        enemy.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e\u00a7cYou cannot attack other players with full Imperial Armor with this weapon!"));
        enemy.setSwimming(true);
        enemy.playNotifySound(SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static void applyImperialDamageReduction(LivingIncomingDamageEvent event) {
        float damage = event.getAmount();
        float newDamage = damage / 100.0f * 10.0f;
        event.setAmount(newDamage);
    }

    private static void handleMobAttacker(LivingIncomingDamageEvent event, Player target, Mob mob) {
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)target;
            serverPlayer.attack((Entity)mob);
        }
    }

    private static boolean handleCarbonArmor(LivingIncomingDamageEvent event, Player player) {
        if (!PlayerDamageEvent.hasFullCarbonArmor(player)) {
            return false;
        }
        PlayerDamageEvent.applyCarbonArmorPenalty(event, player);
        return true;
    }

    private static void applyCarbonArmorPenalty(LivingIncomingDamageEvent event, Player player) {
        float damage = event.getAmount();
        float hurtDamage = damage * 2.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack armorPart = player.getInventory().getArmor(i);
            if (armorPart.getDamageValue() < 1) continue;
            armorPart.hurtAndBreak((int)hurtDamage, (LivingEntity)player, null);
        }
        event.setAmount(damage / 2.0f);
    }

    private static boolean isCorrectWeapon(ItemStack weapon) {
        Set<Item> IMPERIAL_WEAPONS = Set.of((Item)ModItemsAdditions.IMPERIAL_INFINITY_SWORD.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_3D_SWORD.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_AXE.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_PAXEL.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_HAMMER.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_PICKAXE.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_SHOVEL.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_BOW.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_HOE.get());
        return IMPERIAL_WEAPONS.contains(weapon.getItem());
    }

    private static boolean hasFullArmorSet(Player player, Item boots, Item leggings, Item chestplate, Item helmet) {
        return player.getInventory().getArmor(0).getItem() == boots && player.getInventory().getArmor(1).getItem() == leggings && player.getInventory().getArmor(2).getItem() == chestplate && player.getInventory().getArmor(3).getItem() == helmet;
    }

    private static boolean hasFullImperialArmor(Player player) {
        return PlayerDamageEvent.hasFullArmorSet(player, (Item)ModItemsAdditions.IMPERIAL_INFINITY_BOOTS.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_LEGGINGS.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_CHESTPLATE.get(), (Item)ModItemsAdditions.IMPERIAL_INFINITY_HELMET.get());
    }

    private static boolean hasFullCarbonArmor(Player player) {
        return PlayerDamageEvent.hasFullArmorSet(player, (Item)ModItemsAdditions.CARBON_BOOTS.get(), (Item)ModItemsAdditions.CARBON_LEGGINGS.get(), (Item)ModItemsAdditions.CARBON_CHESTPLATE.get(), (Item)ModItemsAdditions.CARBON_HELMET.get());
    }
}

