/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.item.ModArmorMaterials;
import com.Infinity.Nexus.Mod.item.client.parceiros.FractalArmorModel;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FractalArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation START_ANIM = RawAnimation.begin().thenPlay("animation.start").thenLoop("animation.idle");
    private static final RawAnimation FLY_START_ANIM = RawAnimation.begin().thenPlay("animation.fly_start").thenLoop("animation.flying");

    public FractalArmorItem() {
        super(ModArmorMaterials.INFINITY, ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).fireResistant());
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                FractalArmorModel.FractalArmorRenderer renderer = new FractalArmorModel.FractalArmorRenderer((String)itemStack.getOrDefault((DataComponentType)ModDataComponents.FRACTAL_TYPE.get(), (Object)"infinity"));
                return renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "StateController", 20, this::handleAnimations));
    }

    private PlayState handleAnimations(AnimationState<FractalArmorItem> state) {
        AnimationController controller;
        Entity entity = (Entity)state.getData(DataTickets.ENTITY);
        if (!(entity instanceof Player) && !(entity instanceof ArmorStand)) {
            return PlayState.STOP;
        }
        boolean isFlying = false;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean bl = isFlying = player.getAbilities().flying || player.isFallFlying();
        }
        if ((controller = state.getController()).getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(START_ANIM);
            return PlayState.CONTINUE;
        }
        controller.stop();
        if (isFlying) {
            controller.setAnimation(FLY_START_ANIM);
        } else {
            controller.setAnimation(START_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

