/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.ModToolTiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HammerItem
extends DiggerItem {
    public HammerItem(ModToolTiers pTier, Item.Properties pProperties) {
        super((Tier)pTier, BlockTags.MINEABLE_WITH_PICKAXE, pProperties);
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, ServerPlayer player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.getType() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.getDirection() == Direction.DOWN || traceResult.getDirection() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY(), initalBlockPos.getZ() + y));
                }
            }
        }
        if (traceResult.getDirection() == Direction.NORTH || traceResult.getDirection() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY() + y, initalBlockPos.getZ()));
                }
            }
        }
        if (traceResult.getDirection() == Direction.EAST || traceResult.getDirection() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX(), initalBlockPos.getY() + y, initalBlockPos.getZ() + x));
                }
            }
        }
        return positions;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return super.onItemUseFirst(stack, context);
        }
        Player player = context.getPlayer();
        if (player == null) {
            return super.onItemUseFirst(stack, context);
        }
        int maxUses = 6;
        int currentUses = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.HAMMER_RANGE.get(), (Object)0);
        if (player.getOffhandItem().getItem() == ModItemsAdditions.HAMMER_RANGE_UPGRADE.get()) {
            if (currentUses < maxUses) {
                int range = currentUses + 1;
                player.getOffhandItem().shrink(1);
                stack.set((DataComponentType)ModDataComponents.HAMMER_RANGE.get(), (Object)range);
                int increasedArea = range * 2 + (player.getMainHandItem().getItem() == ModItemsAdditions.INFINITY_HAMMER.get() ? 3 : 5);
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7e[\u00a7cINM\u00a7e]\u00a7b: \u00c1rea aumentada para \u00a7f" + increasedArea + "x" + increasedArea)));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7e[\u00a7cINM\u00a7e]\u00a7b: Voc\u00ea atingiu o m\u00e1ximo de usos para este item."));
            }
        } else if (player.getOffhandItem().getItem() == ModItemsAdditions.ADVANCED_CIRCUIT.get()) {
            if (currentUses > 0) {
                int range = currentUses - 1;
                int decreasedArea = range * 2 + (player.getMainHandItem().getItem() == ModItemsAdditions.INFINITY_HAMMER.get() ? 3 : 5);
                player.getOffhandItem().shrink(1);
                context.getLevel().addFreshEntity((Entity)new ItemEntity(context.getLevel(), (double)context.getClickedPos().getX(), (double)context.getClickedPos().getY(), (double)context.getClickedPos().getZ(), ((Item)ModItemsAdditions.HAMMER_RANGE_UPGRADE.get()).getDefaultInstance()));
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7e[\u00a7cINM\u00a7e]\u00a7b: \u00c1rea diminuida para \u00a7f" + decreasedArea + "x" + decreasedArea)));
                stack.set((DataComponentType)ModDataComponents.HAMMER_RANGE.get(), (Object)range);
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7e[\u00a7cINM\u00a7e]\u00a7b: Nao ha nenhum upgrade para remover."));
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }
}

