/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.client.InfinityArmorRenderer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InfinityArmorItem
extends ArmorItem
implements GeoItem {
    private static final int PARTICLE_SOUND_DELAY = 250;
    private static final double PARTICLE_VELOCITY = 0.3;
    private static final double PARTICLE_Y_VELOCITY = -0.2;
    private static final double PARTICLE_RISE_VELOCITY = 0.02;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static int particleDelay;
    private static double lastY;
    private static boolean wasFlying;
    private static boolean isFalling;

    public InfinityArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pEntity;
        boolean hasFullSet = this.hasFullSuitOfArmorOn(player);
        if (hasFullSet && player.getAbilities().mayfly) {
            this.renderParticles(player, pLevel);
        }
    }

    private void renderParticles(Player player, Level level) {
        boolean isCurrentlyFlying = player.getAbilities().flying;
        if (!player.onGround() && !isCurrentlyFlying) {
            double currentY = player.getY();
            if (currentY < lastY) {
                isFalling = true;
            }
            lastY = currentY;
        }
        if (player.onGround()) {
            if (isFalling || wasFlying) {
                this.handleLandingEffects(player, level);
                isFalling = false;
                wasFlying = false;
            }
            lastY = player.getY();
        }
        if (isCurrentlyFlying) {
            wasFlying = true;
            this.handleFlightEffects(player, level);
        }
    }

    private void handleFlightEffects(Player player, Level pLevel) {
        double pitch = player.getXRot();
        double yaw = -player.getYRot() + 90.0f;
        double v = 0.3 * Math.sin(Math.toRadians(yaw));
        double x = player.getX() + v;
        double y = player.getY();
        double z = player.getZ() + 0.3 * Math.cos(Math.toRadians(yaw));
        pLevel.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, y, z, 0.0, -0.2, 0.0);
        x = player.getX() - v;
        z = player.getZ() - 0.3 * Math.cos(Math.toRadians(yaw));
        pLevel.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, y, z, 0.0, -0.2, 0.0);
        if (++particleDelay >= 250) {
            particleDelay = 0;
            pLevel.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FLOWER_GROW, SoundSource.AMBIENT, 0.5f, 0.4f, false);
        }
    }

    private void handleLandingEffects(Player player, Level pLevel) {
        double radius = 0.5;
        double[] radii = new double[]{radius + 0.5, radius + 1.0, radius + 1.5};
        int[] stepSizes = new int[]{15, 10, 5};
        for (int i = 0; i < radii.length; ++i) {
            radius = radii[i];
            int stepSize = stepSizes[i];
            for (int j = 0; j < 360; j += stepSize) {
                double x = player.getX() + radius * Math.cos(Math.toRadians(j));
                double z = player.getZ() + radius * Math.sin(Math.toRadians(j));
                pLevel.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, player.getY(), z, 0.0, 0.02, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.FIREWORK, x, player.getY(), z, 0.0, 0.02, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x, player.getY(), z, 0.0, 0.02, 0.0);
            }
        }
        pLevel.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BIG_FALL, SoundSource.AMBIENT, 0.5f, 0.5f, false);
        pLevel.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.AMBIENT, 0.5f, 0.1f, false);
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        if (player == null) {
            return false;
        }
        return player.getInventory().armor.stream().allMatch(stack -> {
            if (stack.isEmpty()) {
                return false;
            }
            Item item = stack.getItem();
            return item == ModItemsAdditions.INFINITY_BOOTS.get() || item == ModItemsAdditions.INFINITY_LEGGINGS.get() || item == ModItemsAdditions.INFINITY_CHESTPLATE.get() || item == ModItemsAdditions.INFINITY_HELMET.get();
        });
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.infinity_nexus.infinity_armor"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new InfinityArmorRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            state.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (!(entity instanceof Player)) {
                return PlayState.STOP;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : ((Player)entity).getArmorSlots()) {
                if (stack.isEmpty()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.getItem());
            }
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static {
        lastY = Double.MAX_VALUE;
        wasFlying = false;
        isFalling = false;
    }
}

