/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.component.ModDataComponents;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ItemDislocator
extends Item {
    public ItemDislocator(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand ihand) {
        if (!level.isClientSide() && !Screen.hasShiftDown()) {
            ItemStack stack = player.getItemInHand(ihand);
            player.sendSystemMessage((Component)Component.translatable((String)((Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.DISLOCATOR_ONOFRE.get(), (Object)false) != false ? "chat.infinity_nexus_mod.item_dislocator_off" : "chat.infinity_nexus_mod.item_dislocator_on")));
            stack.set((DataComponentType)ModDataComponents.DISLOCATOR_ONOFRE.get(), (Object)((Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.DISLOCATOR_ONOFRE.get(), (Object)false) == false ? 1 : 0));
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.use(level, player, ihand);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.DISLOCATOR_ONOFRE.get(), (Object)false)).booleanValue()) {
                try {
                    List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB(entity.getX() + 5.0, entity.getY() + 5.0, entity.getZ() + 5.0, entity.getX() - 5.0, entity.getY() - 5.0, entity.getZ() - 5.0));
                    for (ItemEntity item : entities) {
                        if (!item.isAlive() || item.hasPickUpDelay()) continue;
                        item.playerTouch(player);
                    }
                }
                catch (Exception e) {
                    System.out.println("\nInfinity Item Dislocator\n" + String.valueOf(e) + "\n\n");
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus_mod.item_dislocator"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.pressShift"));
            tooltipComponents.add((Component)Component.literal((String)((Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.DISLOCATOR_ONOFRE.get(), (Object)false) != false ? "\u00a7aON" : "\u00a7cOFF")));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

