/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.Infinity.Nexus.Mod.component.ModDataComponents;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TranslocatorLink
extends Item {
    public TranslocatorLink(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List positions = (List)stack.getOrDefault((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get(), List.of());
        boolean multiples = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.TRANSLOCATOR_TYPE.get(), (Object)false);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_link_type").append((Component)Component.literal((String)(" " + (multiples ? "Multiples" : "Single")))));
        if (!positions.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_link_cord"));
            for (BlockPos pos : positions) {
                tooltipComponents.add((Component)Component.literal((String)("X: " + pos.getX() + " Y: " + pos.getY() + " Z: " + pos.getZ())));
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            Player player = context.getPlayer();
            BlockPos newPos = context.getClickedPos();
            if (blockEntity instanceof TranslocatorBlockEntityBase) {
                TranslocatorBlockEntityBase translocator = (TranslocatorBlockEntityBase)blockEntity;
                if (!Objects.requireNonNull(player).isShiftKeyDown()) {
                    List positions = (List)stack.getOrDefault((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get(), List.of());
                    translocator.setCords(positions, player);
                } else {
                    ArrayList<BlockPos> existingPositions = new ArrayList<BlockPos>((Collection)stack.getOrDefault((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get(), List.of()));
                    if (existingPositions.contains(newPos)) {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_duplicate")));
                    } else if (existingPositions.size() >= 9) {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_full").append((Component)Component.literal((String)(" " + existingPositions.size())))));
                    } else {
                        existingPositions.add(newPos.immutable());
                        stack.set((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get(), (Object)ImmutableList.copyOf(existingPositions));
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_added", (Object[])new Object[]{newPos.getX(), newPos.getY(), newPos.getZ()})));
                    }
                }
            } else if (Objects.requireNonNull(player).isShiftKeyDown()) {
                if (stack.has((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get())) {
                    stack.remove((DataComponentType)ModDataComponents.TRANSLOCATOR_COORDS.get());
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_clear")));
                } else {
                    boolean multiples = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.TRANSLOCATOR_TYPE.get(), (Object)false);
                    stack.set((DataComponentType)ModDataComponents.TRANSLOCATOR_TYPE.get(), (Object)(!multiples ? 1 : 0));
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").append((Component)Component.translatable((String)"tooltip.infinity_nexus.translocator_link_type").append((Component)Component.literal((String)(" " + (!multiples ? "Multiples" : "Single"))))));
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }
}

