/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.networking.packet;

import com.Infinity.Nexus.Core.utils.GetResourceLocation;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.networking.ModMessages;
import com.Infinity.Nexus.Mod.networking.packet.AreaVisibilityS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleAreaC2SPacket(BlockPos pos, boolean showArea) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleAreaC2SPacket> TYPE = new CustomPacketPayload.Type(GetResourceLocation.withNamespaceAndPath((String)"infinity_nexus_mod", (String)"toggle_area"));
    public static final StreamCodec<FriendlyByteBuf, ToggleAreaC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ToggleAreaC2SPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, ToggleAreaC2SPacket::showArea, ToggleAreaC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ToggleAreaC2SPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity patt0$temp = level.getBlockEntity(packet.pos());
            if (patt0$temp instanceof MobCrusherBlockEntity) {
                MobCrusherBlockEntity blockEntity = (MobCrusherBlockEntity)patt0$temp;
                blockEntity.setShowArea(packet.showArea());
                blockEntity.setChanged();
                for (ServerPlayer nearbyPlayer : level.players()) {
                    if (!(nearbyPlayer.distanceToSqr((double)packet.pos().getX(), (double)packet.pos().getY(), (double)packet.pos().getZ()) < 4096.0)) continue;
                    ModMessages.sendToPlayer(new AreaVisibilityS2CPacket(packet.pos(), packet.showArea()), nearbyPlayer);
                }
                level.sendBlockUpdated(packet.pos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
        });
    }
}

