/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record AssemblerRecipes(NonNullList<Ingredient> inputItems, ItemStack output, int duration, int energy) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput container, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        int matches = 0;
        ArrayList<Integer> matchedSlots = new ArrayList<Integer>();
        block0: for (int ingredientIdx = 0; ingredientIdx < this.inputItems.size(); ++ingredientIdx) {
            Ingredient ingredient = (Ingredient)this.inputItems.get(ingredientIdx);
            for (int slot = 0; slot < 9; ++slot) {
                if (matchedSlots.contains(slot) || !ingredient.test(container.getItem(slot))) continue;
                matchedSlots.add(slot);
                ++matches;
                continue block0;
            }
        }
        return matches >= 9;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput container, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.ASSEMBLY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.ASSEMBLY_RECIPE_TYPE.get();
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDuration() {
        return this.duration;
    }

    public static class Serializer
    implements RecipeSerializer<AssemblerRecipes> {
        public static final MapCodec<AssemblerRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.size() > 9) {
                return DataResult.error(() -> "Too many ingredients, max 9");
            }
            NonNullList nl = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
            for (int i = 0; i < list.size(); ++i) {
                nl.set(i, (Object)((Ingredient)list.get(i)));
            }
            return DataResult.success((Object)nl);
        }, nl -> DataResult.success(nl.stream().filter(ing -> !ing.isEmpty()).toList())).forGetter(AssemblerRecipes::inputItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(AssemblerRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(AssemblerRecipes::duration), (App)Codec.INT.fieldOf("energy").forGetter(AssemblerRecipes::energy)).apply((Applicative)inst, AssemblerRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AssemblerRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (int)9), AssemblerRecipes::inputItems, (StreamCodec)ItemStack.STREAM_CODEC, AssemblerRecipes::output, (StreamCodec)ByteBufCodecs.INT, AssemblerRecipes::duration, (StreamCodec)ByteBufCodecs.INT, AssemblerRecipes::energy, AssemblerRecipes::new);

        public MapCodec<AssemblerRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AssemblerRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

