/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record CompactorRecipes(List<Ingredient> inputItems, ItemStack output) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput multipleMachinesRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        for (int i = 0; i < this.inputItems.size(); ++i) {
            if (this.inputItems.get(i).test(multipleMachinesRecipeInput.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return (NonNullList)this.inputItems;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput multipleMachinesRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.COMPACTOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.COMPACTOR_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CompactorRecipes> {
        public static final MapCodec<CompactorRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.listOf(0, 27).fieldOf("ingredients").forGetter(o -> o.inputItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(CompactorRecipes::output)).apply((Applicative)inst, CompactorRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompactorRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (int)27), CompactorRecipes::inputItems, (StreamCodec)ItemStack.STREAM_CODEC, CompactorRecipes::output, CompactorRecipes::new);

        public MapCodec<CompactorRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CompactorRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

