/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.recipe.ModRecipes;
import com.Infinity.Nexus.Mod.recipe.MultipleMachinesRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;

public record SqueezerRecipes(@Nonnull List<SizedIngredient> ingredients, ItemStack output, int duration, int energy, FluidStack fluidStack) implements Recipe<MultipleMachinesRecipeInput>
{
    public boolean matches(MultipleMachinesRecipeInput inputs, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (!this.ingredients.get(0).test(inputs.getItem(0))) {
            return false;
        }
        return this.ingredients.get(1).test(inputs.getItem(1));
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.ingredients.forEach(i -> list.add((Object)i.ingredient()));
        return list;
    }

    public ItemStack assemble(MultipleMachinesRecipeInput inputs, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SQUEEZER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SQUEEZER_RECIPE_TYPE.get();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEnergy() {
        return this.energy;
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public static class Serializer
    implements RecipeSerializer<SqueezerRecipes> {
        public static final MapCodec<SqueezerRecipes> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(SqueezerRecipes::ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(SqueezerRecipes::output), (App)Codec.INT.fieldOf("duration").forGetter(SqueezerRecipes::getDuration), (App)Codec.INT.fieldOf("energy").forGetter(SqueezerRecipes::getEnergy), (App)FluidStack.CODEC.fieldOf("fluidType").forGetter(SqueezerRecipes::getFluid)).apply((Applicative)inst, SqueezerRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SqueezerRecipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), SqueezerRecipes::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, SqueezerRecipes::output, (StreamCodec)ByteBufCodecs.INT, SqueezerRecipes::getDuration, (StreamCodec)ByteBufCodecs.INT, SqueezerRecipes::getEnergy, (StreamCodec)FluidStack.STREAM_CODEC, SqueezerRecipes::getFluid, SqueezerRecipes::new);

        public MapCodec<SqueezerRecipes> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SqueezerRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

