/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.fermentation;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.screen.BaseAbstractContainerMenu;
import com.Infinity.Nexus.Core.slots.FluidItemSlot;
import com.Infinity.Nexus.Core.slots.InputSlot;
import com.Infinity.Nexus.Core.slots.ResultSlot;
import com.Infinity.Nexus.Mod.block.ModBlocksAdditions;
import com.Infinity.Nexus.Mod.block.entity.FermentationBarrelBlockEntity;
import com.Infinity.Nexus.Mod.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FermentationBarrelMenu
extends BaseAbstractContainerMenu {
    public final FermentationBarrelBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int slots = 4;

    public FermentationBarrelMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, (FermentationBarrelBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2), new RestrictedItemStackHandler(4));
    }

    public FermentationBarrelMenu(int pContainerId, Inventory inv, FermentationBarrelBlockEntity entity, ContainerData data, RestrictedItemStackHandler iItemHandler) {
        super((MenuType)ModMenuTypes.FERMENTATION_BARREL_MENU.get(), pContainerId, 4);
        FermentationBarrelMenu.checkContainerSize((Container)inv, (int)4);
        this.blockEntity = entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new FluidItemSlot(iItemHandler, 0, 44, 6));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 1, 44, 52));
        this.addSlot((Slot)new InputSlot(iItemHandler, 2, 116, 6));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 3, 116, 52));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public FermentationBarrelBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 27;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean stillValid(Player pPlayer) {
        return FermentationBarrelMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocksAdditions.FERMENTATION_BARREL.get()));
    }
}

