/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.mobcrusher;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import com.Infinity.Nexus.Core.screen.BaseAbstractContainerMenu;
import com.Infinity.Nexus.Core.slots.ComponentSlot;
import com.Infinity.Nexus.Core.slots.FuelSlot;
import com.Infinity.Nexus.Core.slots.LinkSlot;
import com.Infinity.Nexus.Core.slots.ResultSlot;
import com.Infinity.Nexus.Core.slots.SwordSlot;
import com.Infinity.Nexus.Core.slots.UpgradeSlot;
import com.Infinity.Nexus.Mod.block.ModBlocksAdditions;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MobCrusherMenu
extends BaseAbstractContainerMenu {
    public final MobCrusherBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int slots = 17;

    public MobCrusherMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, (MobCrusherBlockEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(12), new RestrictedItemStackHandler(17));
    }

    public MobCrusherMenu(int pContainerId, Inventory inv, MobCrusherBlockEntity entity, ContainerData data, RestrictedItemStackHandler iItemHandler) {
        super((MenuType)ModMenuTypes.MOB_CRUSHER_MENU.get(), pContainerId, 17);
        MobCrusherMenu.checkContainerSize((Container)inv, (int)17);
        this.blockEntity = entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new ResultSlot(iItemHandler, 0, 80, 11));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 1, 98, 11));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 2, 116, 11));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 3, 80, 29));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 4, 98, 29));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 5, 116, 29));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 6, 80, 47));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 7, 98, 47));
        this.addSlot((Slot)new ResultSlot(iItemHandler, 8, 116, 47));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 9, -11, 11));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 10, -11, 23));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 11, -11, 35));
        this.addSlot((Slot)new UpgradeSlot(iItemHandler, 12, -11, 47));
        this.addSlot((Slot)new ComponentSlot(iItemHandler, 13, 8, 29));
        this.addSlot((Slot)new SwordSlot(iItemHandler, 14, 44, 11));
        this.addSlot((Slot)new LinkSlot(iItemHandler, 15, 44, 29));
        this.addSlot((Slot)new FuelSlot(iItemHandler, 16, 44, 47));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public MobCrusherBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 14;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean stillValid(Player pPlayer) {
        return MobCrusherMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocksAdditions.MOB_CRUSHER.get()));
    }
}

