/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.mobcrusher;

import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.FluidTankRenderer;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.renderer.RenderScreenTooltips;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.networking.ModMessages;
import com.Infinity.Nexus.Mod.networking.packet.ToggleAreaC2SPacket;
import com.Infinity.Nexus.Mod.screen.mobcrusher.MobCrusherMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class MobCrusherScreen
extends AbstractContainerScreen<MobCrusherMenu>
implements GuiEventListener {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"infinity_nexus_mod", (String)"textures/gui/mob_crusher_gui.png");
    private static final int ENERGY_BAR_X_OFFSET = 159;
    private static final int ENERGY_BAR_Y_OFFSET = 6;
    private EnergyInfoArea energyInfoArea;
    private FluidTankRenderer fluidRenderer;
    private static boolean showArea;
    private Button areaButton;

    public MobCrusherScreen(MobCrusherMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
        this.assignFluidTank();
        this.initializeAreaButton();
    }

    private void initializeAreaButton() {
        showArea = ((MobCrusherMenu)this.menu).blockEntity.shouldShowArea();
        this.areaButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)" "), this::onAreaButtonClick).tooltip(Tooltip.create((Component)Component.translatable((String)(showArea ? "gui.infinity_nexus_mod.mob_crusher.hide_area" : "gui.infinity_nexus_mod.mob_crusher.show_area")))).bounds(this.leftPos + 151, this.topPos - 10, 8, 9).size(8, 9).build());
        this.areaButton.setAlpha(0.0f);
    }

    private void onAreaButtonClick(Button button) {
        showArea = !showArea;
        button.setTooltip(Tooltip.create((Component)Component.translatable((String)(showArea ? "gui.infinity_nexus_mod.mob_crusher.hide_area" : "gui.infinity_nexus_mod.mob_crusher.show_area"))));
        if (((MobCrusherMenu)this.menu).blockEntity != null && ((MobCrusherMenu)this.menu).blockEntity.getLevel() != null && ((MobCrusherMenu)this.menu).blockEntity.getLevel().isClientSide()) {
            ModMessages.sendToServer(new ToggleAreaC2SPacket(((MobCrusherMenu)this.menu).blockEntity.getBlockPos(), showArea));
        }
    }

    private void assignFluidTank() {
        this.fluidRenderer = new FluidTankRenderer(MobCrusherBlockEntity.getFluidCapacity(), true, 6, 62);
    }

    private void assignEnergyInfoArea() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 159, y + 6, ((MobCrusherMenu)this.menu).getBlockEntity().getEnergyStorage());
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.setupRenderSystem();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (Screen.hasShiftDown() || this.isMouseAboveArea(pMouseX, pMouseY, x, y, -15, 10, 17, 54)) {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 15), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        } else {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 3), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        }
        this.renderMainGui(guiGraphics, x, y);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.render(guiGraphics);
        this.fluidRenderer.render(guiGraphics, x + 146, y + 6, ((MobCrusherMenu)this.menu).blockEntity.getFluid());
    }

    private void setupRenderSystem() {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    private void renderMainGui(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((MobCrusherMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 81, y + 29, 176, 0, 16, ((MobCrusherMenu)this.menu).getScaledProgress());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int y;
        int x = (this.width - this.imageWidth) / 2;
        int index = y = (this.height - this.imageHeight) / 2;
        int hasRedstoneSignal = ((MobCrusherMenu)this.menu).getBlockEntity().getHasRedstoneSignal();
        int hasComponent = ((MobCrusherMenu)this.menu).getBlockEntity().getHasComponent();
        int hasEnoughEnergy = ((MobCrusherMenu)this.menu).getBlockEntity().getHasEnoughEnergy();
        int hasSlotFree = ((MobCrusherMenu)this.menu).getBlockEntity().getHasSlotFree();
        int hasRecipe = ((MobCrusherMenu)this.menu).getBlockEntity().getHasRecipe();
        String hasLink = ((MobCrusherMenu)this.menu).getBlockEntity().getHasLink();
        ItemStack linkedBlock = ((MobCrusherMenu)this.menu).getBlockEntity().getLikedBlock();
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (hasComponent == 0) {
            guiGraphics.drawString(this.font, "Component: [Missing]", x + 196, index, 0xFF0000);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)ModItems.REDSTONE_COMPONENT.get()), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.drawString(this.font, "Component: [Ok]", x + 196, index, 65280);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)ModItems.REDSTONE_COMPONENT.get()), x + 178, index - 4);
            index += 15;
        }
        if (hasRecipe == 1) {
            guiGraphics.drawString(this.font, "Mobs: [Scanning]", x + 196, index, 11992832);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)Items.CRAFTING_TABLE), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.drawString(this.font, "Mobs: [Scanning]", x + 196, index, 11992832);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)Items.CRAFTING_TABLE), x + 178, index - 4);
            index += 15;
        }
        if (hasComponent >= 1) {
            int range = hasComponent - 1;
            guiGraphics.drawString(this.font, "Range: " + (range + range + 1) + "x3x" + (range + range + 1), x + 196, index, 11992832);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)ModItemsAdditions.TERRAIN_MARKER.get()), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.drawString(this.font, "Range: 0", x + 196, index, 11992832);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)ModItemsAdditions.TERRAIN_MARKER.get()), x + 178, index - 4);
            index += 15;
        }
        if (linkedBlock != null && linkedBlock.getItem() != Items.AIR) {
            guiGraphics.drawString(this.font, hasLink, x + 196, index, 65280);
            guiGraphics.renderFakeItem(linkedBlock, x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.drawString(this.font, hasLink, x + 196, index, 11992832);
            guiGraphics.renderFakeItem(new ItemStack((ItemLike)ModItems.LINKING_TOOL.get()), x + 178, index - 4);
            index += 15;
        }
    }

    private void renderFluidAreaTooltips(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.renderTooltip(this.font, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.NORMAL), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 159, 6, 6, 62)) {
            pGuiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (Screen.hasShiftDown()) {
            if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, -12, 10, 17, 53)) {
                RenderScreenTooltips.renderUpgradeSlotTooltipAndItems((Font)this.font, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 7, 28, 17, 17)) {
                RenderScreenTooltips.renderComponentSlotTooltipAndItems((Font)this.font, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 145, 6, 6, 62)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Experience"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 79, 10, 53, 53)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 10, 17, 17)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Sword Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 28, 17, 17)) {
                List<MutableComponent> linkingTooltip = List.of(Component.translatable((String)"tooltip.infinity_nexus_miner.linking_slot_tooltip"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, linkingTooltip, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 46, 17, 17)) {
                List<MutableComponent> fuelTooltip = List.of(Component.translatable((String)"tooltip.infinity_nexus_miner.fuel_slot_tooltip"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, fuelTooltip, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            }
        }
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, 8, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, this.title, 8, -9, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        this.renderFluidAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y, ((MobCrusherMenu)this.menu).blockEntity.getFluid(), 146, 6, this.fluidRenderer);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)renderer.getWidth(), (int)renderer.getHeight());
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }

    public void removed() {
        super.removed();
        if (((MobCrusherMenu)this.menu).blockEntity.shouldShowArea() != showArea) {
            // empty if block
        }
    }
}

