/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.solar;

import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.screen.solar.SolarMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarScreen
extends AbstractContainerScreen<SolarMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"infinity_nexus_mod", (String)"textures/gui/solar_gui.png");
    private EnergyInfoArea energyInfoArea;

    public SolarScreen(SolarMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
    }

    private void assignEnergyInfoArea() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 159, y + 6, ((SolarMenu)this.menu).getBlockEntity().getEnergyStorage(Direction.UP));
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.render(guiGraphics);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((SolarMenu)this.menu).isCrafting()) {
            if (((SolarMenu)this.menu).blockEntity.getTime()) {
                guiGraphics.blit(TEXTURE, x + 80, y + 11, 176, 0, 16, 16);
            } else {
                guiGraphics.blit(TEXTURE, x + 80, y + 11, 176, 16, 16, 16);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, 8, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, "Generation Rate: " + ((SolarMenu)this.menu).blockEntity.getGenerationRate(), 8, 35, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, this.title, 8, -9, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 159, 6, 6, 62)) {
            pGuiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }
}

