/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.squeezer;

import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.FluidTankRenderer;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.renderer.RenderScreenTooltips;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.block.entity.SqueezerBlockEntity;
import com.Infinity.Nexus.Mod.screen.squeezer.SqueezerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;

public class SqueezerScreen
extends AbstractContainerScreen<SqueezerMenu>
implements GuiEventListener {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"infinity_nexus_mod", (String)"textures/gui/squeezer_gui.png");
    private EnergyInfoArea energyInfoArea;
    private FluidTankRenderer fluidRenderer;

    public SqueezerScreen(SqueezerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
        this.assignFluidTank();
    }

    private void assignFluidTank() {
        this.fluidRenderer = new FluidTankRenderer(SqueezerBlockEntity.getFluidCapacity(), true, 6, 62);
    }

    private void assignEnergyInfoArea() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 159, y + 6, ((SqueezerMenu)this.menu).getBlockEntity().getEnergyStorage());
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (Screen.hasShiftDown() || this.isMouseAboveArea(pMouseX, pMouseY, x, y, -15, 10, 17, 54)) {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 15), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        } else {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 3), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        }
        guiGraphics.blit(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.render(guiGraphics);
        this.fluidRenderer.render(guiGraphics, x + 146, y + 6, ((SqueezerMenu)this.menu).blockEntity.getFluid());
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((SqueezerMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 81, y + 29, 176, 0, 16, ((SqueezerMenu)this.menu).getScaledProgress());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderFluidAreaTooltips(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.renderTooltip(this.font, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.NORMAL), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 159, 6, 6, 62)) {
            pGuiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (Screen.hasShiftDown()) {
            if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, -12, 10, 17, 53)) {
                RenderScreenTooltips.renderUpgradeSlotTooltipAndItems((Font)this.font, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 7, 28, 17, 17)) {
                RenderScreenTooltips.renderComponentSlotTooltipAndItems((Font)this.font, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 145, 6, 6, 62)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Output Fluid"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 124, 6, 17, 17)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Container Fluid Input Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 124, 52, 17, 17)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Container Fluid Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 79, 6, 17, 17)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Input Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 79, 51, 17, 17)) {
                List<MutableComponent> components = List.of(Component.literal((String)"Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.font, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            }
        }
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, 8, 74, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, this.title, 8, -9, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        this.renderFluidAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y, ((SqueezerMenu)this.menu).blockEntity.getFluid(), 146, 6, this.fluidRenderer);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)renderer.getWidth(), (int)renderer.getHeight());
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }
}

