/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.custom;

import com.Infinity.Nexus.Mod.block.custom.common.CommonUpgrades;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.TankBlockEntity;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tank
extends BaseEntityBlock {
    public static IntegerProperty LIT = IntegerProperty.m_61631_((String)"lit", (int)0, (int)1);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public Tank(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof TankBlockEntity) {
            ((TankBlockEntity)blockEntity).drops();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pPlayer.m_21205_().m_150930_(Items.f_42446_.m_5456_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof TankBlockEntity) {
                TankBlockEntity tank = (TankBlockEntity)blockEntity;
                tank.fillBucket(pPlayer.m_21205_(), pPlayer, pLevel);
            }
        } else {
            CommonUpgrades.setUpgrades(pLevel, pPos, pPlayer);
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)pStack.m_41737_("Fluid"));
        TankBlockEntity entity = (TankBlockEntity)pLevel.m_7702_(pPos);
        if (entity != null && !pLevel.m_5776_()) {
            entity.fillFluidFromNBT(stack);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TankBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return Tank.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TANK_BE.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)pStack.m_41737_("Fluid"));
        if (!stack.equals((Object)FluidStack.EMPTY)) {
            boolean endless = stack.getAmount() >= ConfigUtils.tank_capacity;
            pTooltip.add((Component)Component.m_237113_((String)(stack.getDisplayName().getString() + (endless ? " (" + Component.m_237115_((String)"tooltip.infinity_nexus_mod.tank_endless").getString() + ")" : " " + stack.getAmount() + "mB/" + ConfigUtils.tank_capacity + "mB"))));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.infinity_nexus_mod.tank_empty").m_7220_((Component)Component.m_237113_((String)(": 0mB/" + ConfigUtils.tank_capacity + "mB"))));
        }
        if (ConfigUtils.tank_can_endless) {
            if (Screen.m_96638_()) {
                pTooltip.add((Component)Component.m_237115_((String)"item.infinity_nexus.tank_description"));
            } else {
                pTooltip.add((Component)Component.m_237115_((String)"tooltip.infinity_nexus.pressShift"));
            }
        }
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

