/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Mod.block.custom.Compactor;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.recipe.CompactorRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CompactorBlockEntity
extends BlockEntity {
    private boolean redstone = false;
    private int progress = 0;
    private int maxProgress = 100;

    public CompactorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.COMPACTOR_BE.get(), pPos, pBlockState);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        boolean isPowered = this.isRedstonePowered(pPos);
        if (this.progress < this.maxProgress) {
            ++this.progress;
        } else {
            this.progress = 0;
            this.verifySpace(pLevel, pPos);
        }
        if (isPowered != this.redstone) {
            this.redstone = isPowered;
            if (isPowered && this.verifySpace(pLevel, pPos)) {
                this.craft(pLevel, pPos);
            }
        }
        this.m_6596_();
    }

    private void craft(Level pLevel, BlockPos pPos) {
        Optional<CompactorRecipes> recipe = this.getCurrentRecipe();
        if (!recipe.isEmpty()) {
            AABB aabb = new AABB(pPos.m_6630_(4).m_122030_(2).m_122020_(2), pPos.m_7494_().m_122024_().m_122012_());
            List entities = this.f_58857_.m_45976_(ItemEntity.class, aabb);
            ServerLevel level = (ServerLevel)this.m_58904_();
            if (!entities.isEmpty()) {
                ((ItemEntity)entities.get(0)).m_142687_(Entity.RemovalReason.DISCARDED);
                ItemStack result = recipe.get().m_8043_(pLevel.m_9598_());
                ItemEntity output = new ItemEntity((Level)level, (double)pPos.m_123341_(), (double)(pPos.m_123342_() + 2), (double)pPos.m_123343_(), result.m_41777_());
                level.m_7967_((Entity)output);
                this.removeBlocks();
            }
        }
    }

    private boolean verifySpace(Level pLevel, BlockPos pPos) {
        boolean free = true;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos adjacentPos;
                BlockState adjacentState;
                if (x == 0 && z == 0 || (adjacentState = pLevel.m_8055_(adjacentPos = pPos.m_7918_(x, 0, z))).m_60734_() == Blocks.f_50375_) continue;
                free = false;
            }
        }
        if (free) {
            pLevel.m_7731_(pPos, (BlockState)this.m_58900_().m_61124_((Property)Compactor.LIT, (Comparable)Integer.valueOf(0)), 3);
        } else {
            pLevel.m_7731_(pPos, (BlockState)this.m_58900_().m_61124_((Property)Compactor.LIT, (Comparable)Integer.valueOf(1)), 3);
        }
        return free;
    }

    private void removeBlocks() {
        int centerX = this.f_58858_.m_123341_();
        int centerY = this.f_58858_.m_123342_() + 2;
        int centerZ = this.f_58858_.m_123343_();
        BlockPos center = new BlockPos(centerX, centerY, centerZ);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y >= -1; --y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = new BlockPos(centerX + x, centerY + y, centerZ + z);
                    if (center.equals((Object)pos)) continue;
                    this.f_58857_.m_46961_(pos, false);
                }
            }
        }
    }

    private Optional<CompactorRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(27);
        int centerX = this.f_58858_.m_123341_();
        int centerY = this.f_58858_.m_123342_() + 2;
        int centerZ = this.f_58858_.m_123343_();
        int index = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    BlockPos pos = new BlockPos(centerX + x, centerY + y, centerZ + z);
                    if (x == 0 && y == 0 && z == 0) {
                        ItemStack centerItem;
                        AABB aabb = new AABB(pos.m_7495_().m_122030_(2).m_122020_(2), pos.m_7494_().m_122012_().m_122024_());
                        List entities = this.f_58857_.m_45976_(ItemEntity.class, aabb);
                        if (entities.isEmpty() || (centerItem = ((ItemEntity)entities.get(0)).m_32055_()).m_41613_() != 1) continue;
                        inventory.m_6836_(index++, centerItem);
                        continue;
                    }
                    BlockState state = this.f_58857_.m_8055_(pos);
                    ItemStack item = new ItemStack((ItemLike)state.m_60734_().m_5456_());
                    inventory.m_6836_(index++, item);
                }
            }
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)CompactorRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos.m_122012_()) || this.f_58857_.m_276867_(pPos.m_122019_()) || this.f_58857_.m_276867_(pPos.m_122024_()) || this.f_58857_.m_276867_(pPos.m_122029_());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void onRemove() {
    }

    public void onPlace() {
    }
}

