/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Mod.screen.placer.PlacerMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DepotBlockEntityBase
extends BlockEntity
implements MenuProvider {
    int timer = 0;
    int maxTimer = 20;
    int count = 1;
    final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DepotBlockEntityBase.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return DepotBlockEntityBase.this.count;
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return DepotBlockEntityBase.this.count;
        }
    };

    public DepotBlockEntityBase(@NotNull BlockEntityType<? extends DepotBlockEntityBase> blockEntityType, BlockPos pPos, BlockState pBlockState) {
        super(blockEntityType, pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.placer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PlacerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("count", this.count);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.count = pTag.m_128451_("count");
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (this.canPlace(pPos)) {
            this.place();
            DepotBlockEntityBase.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    protected void place() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        int amount = Math.min(this.itemHandler.getStackInSlot(0).m_41613_(), this.count);
        if (!stack.m_41619_()) {
            ItemStack stack2 = stack.m_41777_();
            stack2.m_41764_(amount);
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack2);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_149678_();
            entity.m_32010_(10);
            this.f_58857_.m_7967_((Entity)entity);
            this.itemHandler.getStackInSlot(0).m_41774_(amount);
        }
    }

    protected boolean hasEntity(BlockPos pPos) {
        List entities = this.f_58857_.m_45976_(ItemEntity.class, new AABB(pPos));
        if (!entities.isEmpty()) {
            entities.forEach(entity -> entity.m_32010_(10));
        }
        return entities.isEmpty();
    }

    boolean hasProgressFinished() {
        this.timer = this.timer < this.maxTimer ? ++this.timer : 0;
        return this.timer >= this.maxTimer;
    }

    protected boolean canPlace(BlockPos pPos) {
        return this.hasEntity(pPos);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setStack(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            this.itemHandler.setStackInSlot(0, itemStack.m_41777_());
            player.m_21205_().m_41774_(player.m_21205_().m_41613_());
        }
    }

    public void setCount(Player player) {
        this.count = this.count < 64 ? this.count + 1 : 1;
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eQuantidade alterada para: " + this.count)));
    }
}

