/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Mod.block.custom.ItemDisplay;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayBlockEntity
extends BlockEntity {
    protected final ContainerData data;
    float rotation = 0.0f;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DisplayBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(0).m_41619_() ? ItemStack.f_41583_ : this.itemHandler.getStackInSlot(0);
    }

    public DisplayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DISPLAY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return 0;
            }

            public void m_8050_(int pIndex, int pValue) {
            }

            public int m_6499_() {
                return 0;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public float getRotation() {
        this.rotation = this.rotation < 360.0f ? (float)((double)this.rotation + ConfigUtils.display_rotation_speed_multiplier) : 0.0f;
        return this.rotation;
    }

    public void setRenderStack(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            if (!player.m_21205_().m_41619_()) {
                ItemStack stack = itemStack.m_41777_();
                this.itemHandler.setStackInSlot(0, stack);
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11682_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(stack.m_41613_());
                }
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e Display atualizado!"));
                this.setBlockModel(this.itemHandler.getStackInSlot(0));
            }
        } else if (!player.m_21205_().m_41619_()) {
            if (player.m_21205_().m_150930_(this.itemHandler.getStackInSlot(0).m_41720_())) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eO \u00e9 igual ao do display!"));
                return;
            }
            ItemStack stack = itemStack.m_41777_();
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.itemHandler.getStackInSlot(0).m_41777_()));
            this.itemHandler.setStackInSlot(0, stack);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11682_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(stack.m_41613_());
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eDisplay atualizado!"));
            this.setBlockModel(this.itemHandler.getStackInSlot(0));
        } else if (player.m_6144_()) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.itemHandler.getStackInSlot(0).m_41777_()));
            this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7eItem removido do display!"));
            this.setBlockModel(this.itemHandler.getStackInSlot(0));
        }
        this.m_6596_();
    }

    private void setBlockModel(ItemStack itemStack) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(1)), 3);
        if (itemStack.m_41720_() instanceof BlockItem) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(0)), 3);
        } else if (itemStack.m_41720_() instanceof SwordItem) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(6)), 3);
        } else if (itemStack.m_41720_() instanceof DiggerItem) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(7)), 3);
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ItemDisplay.LIT, (Comparable)Integer.valueOf(4)), 3);
        }
    }
}

