/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Factory;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.FactoryHandler;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.FactoryRecipes;
import com.Infinity.Nexus.Mod.screen.factory.FactoryMenu;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(22){

        protected void onContentsChanged(int slot) {
            FactoryBlockEntity.this.m_6596_();
            assert (FactoryBlockEntity.this.f_58857_ != null);
            if (!FactoryBlockEntity.this.f_58857_.m_5776_()) {
                FactoryBlockEntity.this.f_58857_.m_7260_(FactoryBlockEntity.this.m_58899_(), FactoryBlockEntity.this.m_58900_(), FactoryBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 16 -> false;
                case 17, 18, 19, 20 -> ModUtils.isUpgrade((ItemStack)stack);
                case 21 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot <= 7) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 0 || slot > 15) {
                return super.insertItem(slot, stack, simulate);
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (simulate) {
                ItemStack existing = this.getStackInSlot(slot);
                if (existing.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                return stack;
            }
            for (int i = 0; i <= 15; ++i) {
                ItemStack existingStack = this.getStackInSlot(i);
                if (!existingStack.m_41619_()) continue;
                ItemStack singleItem = stack.m_41777_();
                singleItem.m_41764_(1);
                this.setStackInSlot(i, singleItem);
                ItemStack remainder = stack.m_41777_();
                remainder.m_41774_(1);
                return remainder;
            }
            return stack;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot <= 15) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private static final int INPUT_SLOT = 15;
    private static final int OUTPUT_SLOT = 16;
    private static final int[] UPGRADE_SLOTS = new int[]{17, 18, 19, 20};
    private static final int COMPONENT_SLOT = 21;
    private static final int EnergyStorageCapacity = 60000;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private static final int ENERGY_REQ = 32;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.UP), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.DOWN), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.NORTH), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.SOUTH), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.EAST), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> FactoryHandler.extract(i, Direction.WEST), (i, s) -> FactoryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())));
    protected final ContainerData data;
    private int progress = 0;
    public int maxProgress = 0;
    public ItemStack recipeOutput = ItemStack.f_41583_;

    public static int getComponentSlot() {
        return 21;
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(60000, 640){

            public void onEnergyChanged() {
                FactoryBlockEntity.this.m_6596_();
                FactoryBlockEntity.this.m_58904_().m_7260_(FactoryBlockEntity.this.m_58899_(), FactoryBlockEntity.this.m_58900_(), FactoryBlockEntity.this.m_58900_(), 3);
            }
        };
    }

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(slot).m_41619_() ? ItemStack.f_41583_ : this.itemHandler.getStackInSlot(slot);
    }

    public FactoryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FACTORY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FactoryBlockEntity.this.progress;
                    case 1 -> FactoryBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FactoryBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FactoryBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Factory.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("factory.progress", this.progress);
        pTag.m_128405_("factory.maxProgress", this.maxProgress);
        pTag.m_128405_("factory.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag.m_128365_("recipeOutput", (Tag)this.recipeOutput.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("factory.progress");
        this.maxProgress = pTag.m_128451_("factory.maxProgress");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("factory.energy"));
        this.recipeOutput = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("recipeOutput"));
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.factory").m_130946_(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FactoryMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Factory.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.hasRecipe()) {
            this.resetProgress();
            return;
        }
        this.setMaxProgress(machineLevel);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Factory.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractEnergy(this);
        FactoryBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.m_7494_(), (int[])UPGRADE_SLOTS, (int[])new int[]{16}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractEnergy(FactoryBlockEntity factoryBlockEntity) {
        int energy = this.getCurrentRecipe().get().getEnergy();
        int machineLevel = this.getMachineLevel() + 1;
        int maxProgress = factoryBlockEntity.maxProgress;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) + 1;
        int strength = ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) * 10;
        int var1 = (energy + machineLevel * 20) / maxProgress * (speed + machineLevel);
        int var2 = Math.multiplyExact(strength, var1 / 100);
        int extractEnergy = var1 - var2;
        factoryBlockEntity.ENERGY_STORAGE.extractEnergy(Math.max(extractEnergy, 1), false);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<FactoryRecipes> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        int[] amountInput = recipe.get().getAmountInput();
        for (int i = 0; i < amountInput.length; ++i) {
            int amount = amountInput[i];
            for (int slot = 0; slot <= 15; ++slot) {
                ItemStack item = this.itemHandler.getStackInSlot(slot);
                if (item.m_41619_() || !((Ingredient)recipe.get().m_7527_().get(i)).test(item) || amount <= 0) continue;
                int extracted = this.itemHandler.extractItem(slot, amount, false).m_41613_();
                amount -= extracted;
            }
        }
        ItemStack component = this.itemHandler.getStackInSlot(21);
        ModUtils.useComponent((ItemStack)component, (Level)this.f_58857_, (BlockPos)this.m_58899_());
        this.itemHandler.setStackInSlot(16, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(16).m_41613_() + result.m_41613_()));
        if (ModUtils.getMuffler((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) < 1) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12375_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private boolean hasRecipe() {
        Optional<FactoryRecipes> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.f_41583_;
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.recipeOutput = result.m_41777_();
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<FactoryRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)FactoryRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(21));
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(16).m_41619_() || this.itemHandler.getStackInSlot(16).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(16).m_41613_() + count <= this.itemHandler.getStackInSlot(16).m_41741_();
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void setMaxProgress(int machineLevel) {
        int duration = this.getCurrentRecipe().get().getDuration();
        int halfDuration = duration / 2;
        int speedReduction = halfDuration / 16;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
        int reducedDuration = speed * speedReduction;
        int reducedLevel = machineLevel * (halfDuration / 8);
        duration = duration - reducedDuration - reducedLevel;
        this.maxProgress = Math.max(duration, ConfigUtils.assembler_minimum_tick);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)21, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }

    public IItemHandler getRecipeInventory() {
        return this.itemHandler;
    }
}

