/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.FermentationBarrel;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.recipe.FermentationBarrelRecipes;
import com.Infinity.Nexus.Mod.screen.fermentation.FermentationBarrelMenu;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            FermentationBarrelBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                case 2 -> true;
                case 1, 3 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final FluidTank inputFluidHandler;
    private static final int INPUT_FLUID_ITEM = 0;
    private static final int OUTPUT_FLUID_ITEM = 1;
    private static final int INPUT_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    private final FluidTank FLUID_STORAGE_INPUT = this.inputFluidHandler = new FluidTank(8000){

        public void onContentsChanged() {
            FermentationBarrelBlockEntity.this.m_6596_();
            if (!FermentationBarrelBlockEntity.this.f_58857_.m_5776_()) {
                FermentationBarrelBlockEntity.this.f_58857_.m_7260_(FermentationBarrelBlockEntity.this.m_58899_(), FermentationBarrelBlockEntity.this.m_58900_(), FermentationBarrelBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }
    };
    private static final int INPUT_FLUID_CAPACITY = 8000;
    private static final int OUTPUT_FLUID_CAPACITY = 8000;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 1, (i, s) -> i == 2 || i == 0 && !ModUtils.isComponent((ItemStack)s) && !ModUtils.isUpgrade((ItemStack)s))));
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 0;
    private double nextTarget = (double)this.maxProgress * 0.025;
    public ItemStack recipeOutput = ItemStack.f_41583_;

    public FermentationBarrelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FERMENTATION_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FermentationBarrelBlockEntity.this.progress;
                    case 1 -> FermentationBarrelBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FermentationBarrelBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FermentationBarrelBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)FermentationBarrel.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_STORAGE_INPUT);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.fermentation_barrel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FermentationBarrelMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public static long getInputFluidCapacity() {
        return 8000L;
    }

    public static long getOutputFluidCapacity() {
        return 8000L;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("fermentation_barrel.progress", this.progress);
        pTag.m_128405_("fermentation_barrel.max_progress", this.maxProgress);
        pTag.m_128365_("recipeOutput", (Tag)this.recipeOutput.serializeNBT());
        pTag = this.FLUID_STORAGE_INPUT.writeToNBT(pTag);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("fermentation_barrel.progress");
        this.maxProgress = pTag.m_128451_("fermentation_barrel.max_progress");
        this.recipeOutput = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("recipeOutput"));
        this.FLUID_STORAGE_INPUT.readFromNBT(pTag);
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public FluidStack getFluidInInputTank() {
        return this.FLUID_STORAGE_INPUT.getFluid();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        this.fillUpOnFluid();
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.hasRecipe()) {
            this.resetProgress();
            return;
        }
        this.setMaxProgress();
        this.increaseCraftingProgress(pPos);
        FermentationBarrelBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.resetProgress();
        }
    }

    private void fillUpOnFluid() {
        if (this.hasFluidSourceInSlot(0)) {
            this.transferItemFluidToTank(0);
        }
    }

    private void transferItemFluidToTank(int fluidInputSlot) {
        this.itemHandler.getStackInSlot(fluidInputSlot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
            if (iFluidHandlerItem.getContainer().m_41720_() instanceof BucketItem) {
                if (this.FLUID_STORAGE_INPUT.getSpace() >= 1000) {
                    FluidStack stack = iFluidHandlerItem.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    this.FLUID_STORAGE_INPUT.fill(new FluidStack(stack.getFluid(), stack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    this.itemHandler.extractItem(0, 1, false);
                    this.itemHandler.setStackInSlot(0, Items.f_42446_.m_7968_());
                    this.removeContainer(iFluidHandlerItem.getContainer(), 0);
                }
            } else if (this.FLUID_STORAGE_INPUT.getSpace() >= 10 || this.FLUID_STORAGE_INPUT.getSpace() >= iFluidHandlerItem.getContainer().m_41613_()) {
                int drainAmount = Math.min(this.FLUID_STORAGE_INPUT.getSpace(), 10);
                FluidStack stack = iFluidHandlerItem.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                iFluidHandlerItem.drain(stack, IFluidHandler.FluidAction.EXECUTE);
                this.FLUID_STORAGE_INPUT.fill(new FluidStack(stack.getFluid(), stack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                this.removeContainer(iFluidHandlerItem.getContainer(), iFluidHandlerItem.getFluidInTank(0).getAmount());
            }
        });
    }

    private void removeContainer(ItemStack container, int fluid) {
        if ((fluid <= 0 || container.m_41720_() instanceof BucketItem) && this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.setStackInSlot(1, container);
        }
    }

    private boolean hasFluidSourceInSlot(int fluidInputSlot) {
        return this.itemHandler.getStackInSlot(fluidInputSlot).m_41613_() > 0 && this.itemHandler.getStackInSlot(fluidInputSlot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    private void setMaxProgress() {
        int time = this.getCurrentRecipe().get().getDuration();
        if (this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60734_() instanceof MyceliumBlock) {
            time /= 2;
        }
        if (this.itemHandler.getStackInSlot(2).m_41720_() == ModItemsAdditions.INFINITY_INGOT.get()) {
            time *= this.itemHandler.getStackInSlot(2).m_41613_();
        }
        this.maxProgress = time;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<FermentationBarrelRecipes> recipe = this.getCurrentRecipe();
        boolean isFermentationRecipe = recipe.get().getRecipeType();
        int recipeFluidInputAmount = recipe.get().getInputFluidStack().getAmount();
        int recipeInputCount = recipe.get().getInputCount();
        int recipeResultCount = recipe.get().m_8043_(null).m_41613_();
        Item stack = recipe.get().m_8043_(null).m_41720_();
        if (!isFermentationRecipe) {
            int inputSlot = this.itemHandler.getStackInSlot(2).m_41613_();
            if (this.itemHandler.getStackInSlot(2).m_41720_().equals(ModItemsAdditions.INFINITY_INGOT.get())) {
                for (int i = 0; i < inputSlot && this.inputFluidHandler.getFluidAmount() >= recipeFluidInputAmount && this.itemHandler.getStackInSlot(2).m_41613_() > 0; ++i) {
                    this.FLUID_STORAGE_INPUT.drain(recipeFluidInputAmount, IFluidHandler.FluidAction.EXECUTE);
                    this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)stack, recipeResultCount + this.itemHandler.getStackInSlot(3).m_41613_()));
                    this.itemHandler.getStackInSlot(2).m_41774_(recipeInputCount);
                }
            } else {
                this.FLUID_STORAGE_INPUT.drain(recipeFluidInputAmount, IFluidHandler.FluidAction.EXECUTE);
                this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)stack, recipeResultCount + this.itemHandler.getStackInSlot(3).m_41613_()));
            }
        } else {
            int inputCount = recipe.get().getInputCount();
            int fluidInputCount = recipe.get().getInputFluidStack().getAmount();
            int recipeFluidOutputAmount = recipe.get().getOutputFluidStack().getAmount();
            FluidStack recipeFluidOutput = recipe.get().getOutputFluidStack();
            recipeFluidOutput.setAmount(recipeFluidOutputAmount);
            while (this.itemHandler.getStackInSlot(2).m_41613_() >= inputCount && this.FLUID_STORAGE_INPUT.getFluidAmount() >= fluidInputCount) {
                this.FLUID_STORAGE_INPUT.drain(recipeFluidInputAmount, IFluidHandler.FluidAction.EXECUTE);
                this.FLUID_STORAGE_INPUT.fill(recipeFluidOutput, IFluidHandler.FluidAction.EXECUTE);
                this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)stack, recipeResultCount + this.itemHandler.getStackInSlot(3).m_41613_()));
                this.itemHandler.getStackInSlot(2).m_41774_(recipeInputCount);
            }
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private boolean hasRecipe() {
        Optional<FermentationBarrelRecipes> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.f_41583_;
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.recipeOutput = result.m_41777_();
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_()) && this.hasFluidInTank();
    }

    private boolean hasFluidInTank() {
        return this.FLUID_STORAGE_INPUT.getFluid().getAmount() >= this.getCurrentRecipe().get().getInputFluidStack().getAmount() && this.FLUID_STORAGE_INPUT.getFluid().getFluid() == this.getCurrentRecipe().get().getInputFluidStack().getFluid();
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(3).m_41613_() + count <= this.itemHandler.getStackInSlot(3).m_41741_();
    }

    private Optional<FermentationBarrelRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)FermentationBarrelRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress(BlockPos pPos) {
        if ((double)this.progress >= this.nextTarget) {
            double x = (double)pPos.m_123341_() + 0.5;
            double y = pPos.m_123342_() + 1;
            double z = (double)pPos.m_123343_() + 0.5;
            ServerLevel level = (ServerLevel)this.m_58904_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y + 0.1, z, 1, 0.0, 0.0, 0.0, 0.01);
            this.nextTarget += (double)this.maxProgress * 0.025;
        }
        ++this.progress;
    }

    public static int getInputSlot() {
        return 2;
    }

    public static int getOutputSlot() {
        return 3;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

