/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Generator;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.SolarBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.GeneratorHandler;
import com.Infinity.Nexus.Mod.screen.generator.GeneratorMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (ForgeHooks.getBurnTime((ItemStack)stack, null) >= 1) {
                        yield true;
                    }
                    yield false;
                }
                case 1, 2, 3, 4 -> ModUtils.isUpgrade((ItemStack)stack);
                case 5 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int[] UPGRADE_SLOTS = new int[]{1, 2, 3, 4};
    private static final int COMPONENT_SLOT = 5;
    private static final int capacity = 60000;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.UP), GeneratorHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.DOWN), GeneratorHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.NORTH), GeneratorHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.SOUTH), GeneratorHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.EAST), GeneratorHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> GeneratorHandler.extract(i, Direction.WEST), GeneratorHandler::insert)));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> GeneratorBlockEntity.this.progress;
                case 1 -> GeneratorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    GeneratorBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    GeneratorBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 0;
    private int fuel = 0;
    private int ENERGY_TRANSFER = 30;

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(60000, 32000){

            public void onEnergyChanged() {
                GeneratorBlockEntity.this.m_6596_();
                GeneratorBlockEntity.this.m_58904_().m_7260_(GeneratorBlockEntity.this.m_58899_(), GeneratorBlockEntity.this.m_58900_(), GeneratorBlockEntity.this.m_58900_(), 4);
            }

            public boolean canExtract() {
                return true;
            }
        };
    }

    public GeneratorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GENERATOR_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Generator.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public static int getComponentSlot() {
        return 5;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.generator").m_130946_(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GeneratorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("generator.progress", this.progress);
        pTag.m_128405_("generator.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("generator.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("generator.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Generator.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.findEnergyCap(machineLevel);
        if (this.getMachineLevel() <= 0) {
            return;
        }
        if (!this.canInsertEnergy(this)) {
            return;
        }
        if (this.fuel <= 0) {
            if (!this.hasFuel(this)) {
                return;
            }
            this.removeFuel();
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Generator.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.insertEnergy();
        this.increaseCraftingProgress();
        this.decreaseFuel();
        GeneratorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.resetProgress();
        }
    }

    private void setMaxTransfer(int machineLevel) {
        int energy = (machineLevel + ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS)) * 30;
        this.ENERGY_TRANSFER = energy <= 0 ? 30 : energy;
    }

    private void findEnergyCap(int machineLevel) {
        try {
            Level level = this.m_58904_();
            BlockPos pos = this.m_58899_();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(direction);
                assert (level != null);
                BlockEntity neighborBlockEntity = level.m_7702_(neighborPos);
                if (neighborBlockEntity == null || neighborBlockEntity instanceof SolarBlockEntity || neighborBlockEntity instanceof GeneratorBlockEntity) continue;
                neighborBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                    this.setMaxTransfer(machineLevel);
                    int amount = Math.min(this.ENERGY_STORAGE.getEnergyStored(), this.ENERGY_TRANSFER);
                    if (energy.canReceive() && energy.getEnergyStored() != energy.getMaxEnergyStored()) {
                        if (energy.getMaxEnergyStored() - energy.getEnergyStored() >= amount) {
                            energy.receiveEnergy(amount, false);
                            this.ENERGY_STORAGE.extractEnergy(amount, false);
                        } else {
                            energy.receiveEnergy(energy.getMaxEnergyStored() - energy.getEnergyStored(), false);
                            this.ENERGY_STORAGE.extractEnergy(energy.getMaxEnergyStored() - energy.getEnergyStored(), false);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
        }
    }

    private void decreaseFuel() {
        this.fuel -= this.getMachineLevel() + 1 + ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
    }

    private void removeFuel() {
        if (this.hasFuel(this)) {
            this.itemHandler.extractItem(0, 1, false);
        }
    }

    private void insertEnergy() {
        try {
            this.ENERGY_STORAGE.receiveEnergy(this.ENERGY_TRANSFER, false);
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
        }
    }

    private boolean canInsertEnergy(GeneratorBlockEntity generatorBlockEntity) {
        try {
            return generatorBlockEntity.ENERGY_STORAGE.getEnergyStored() + this.ENERGY_TRANSFER < generatorBlockEntity.ENERGY_STORAGE.getMaxEnergyStored();
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasFuel(GeneratorBlockEntity generatorBlockEntity) {
        ItemStack fuel = generatorBlockEntity.itemHandler.getStackInSlot(0);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, null);
        this.setMaxProgress(burnTime);
        this.fuel = burnTime;
        return burnTime > 0;
    }

    private void setMaxProgress(int burnTime) {
        this.maxProgress = burnTime;
    }

    private void resetProgress() {
        if (ModUtils.getMuffler((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) < 1) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 1.0f);
        }
        this.progress = 0;
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(5));
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        this.progress += this.getMachineLevel() + 1 + ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
    }

    public static int getInputSlot() {
        return 0;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)5, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

