/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Infuser;
import com.Infinity.Nexus.Mod.block.custom.pedestals.BasePedestal;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.pedestals.CreativityPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.DecorPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.ExplorationPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.MagicPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.ResourcePedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.pedestals.TechPedestalBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.InfuserHandler;
import com.Infinity.Nexus.Mod.recipe.InfuserRecipes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfuserBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            InfuserBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> true;
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    public int maxProgress = 200;
    public ItemStack recipeOutput = ItemStack.f_41583_;
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.UP), InfuserHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.DOWN), InfuserHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.NORTH), InfuserHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.SOUTH), InfuserHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.EAST), InfuserHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> InfuserHandler.extract(i, Direction.WEST), InfuserHandler::insert)));

    public ItemStack getRenderStack() {
        return this.itemHandler.getStackInSlot(0).m_41619_() ? ItemStack.f_41583_ : this.itemHandler.getStackInSlot(0);
    }

    public InfuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.INFUSER_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> InfuserBlockEntity.this.progress;
                    case 1 -> InfuserBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        InfuserBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        InfuserBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Infuser.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("infuser.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("infuser.progress");
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        this.stopPedestalAnimation(this.f_58858_);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            if (this.progress > 0) {
                this.stopPedestalAnimation(pPos);
                this.resetProgress();
            }
            if ((Integer)this.f_58857_.m_8055_(pPos).m_61143_((Property)Infuser.LIT) != 3) {
                this.m_58904_().m_7731_(pPos, (BlockState)pState.m_61124_((Property)Infuser.LIT, (Comparable)Integer.valueOf(3)), 3);
            }
            return;
        }
        if (!this.hasRecipe(pPos)) {
            if (this.progress > 0) {
                this.stopPedestalAnimation(pPos);
            }
            this.resetProgress();
            return;
        }
        int[] pedestals = this.getCurrentRecipe().get().getPedestals();
        this.managePedestals(pLevel, pPos, pState, pedestals);
        this.increaseCraftingProgress();
        InfuserBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.startPedestalAnimation(pPos, false, pedestals);
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.m_7494_(), (int[])new int[]{0}, (int[])new int[]{1}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.m_58904_().m_7731_(pPos, (BlockState)pState.m_61124_((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
            this.resetProgress();
        }
    }

    private void managePedestals(Level pLevel, BlockPos pPos, BlockState pState, int[] pedestals) {
        if (this.progress == 0) {
            this.startPedestalAnimation(pPos, false, pedestals);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Infuser.LIT, (Comparable)Integer.valueOf(1)), 3);
        }
        if (this.progress == 1) {
            this.startPedestalAnimation(pPos, true, pedestals);
        }
        if (this.progress == 180) {
            this.summonLightning(pPos);
        }
    }

    private void startPedestalAnimation(BlockPos pos, boolean work, int[] pedestals) {
        Map<Integer, BlockPos> pedestalPositions = Map.of(1, pos.m_122025_(2).m_122020_(1), 2, pos.m_122025_(2).m_122013_(1), 3, pos.m_122013_(2), 4, pos.m_122030_(2).m_122013_(1), 5, pos.m_122030_(2).m_122020_(1), 6, pos.m_122020_(2));
        for (int pedestalIndex : pedestals) {
            BlockPos pedestalPos = pedestalPositions.get(pedestalIndex);
            if (pedestalPos == null) continue;
            this.f_58857_.m_7731_(pedestalPos, (BlockState)this.f_58857_.m_8055_(pedestalPos).m_61124_((Property)BasePedestal.WORK, (Comparable)Boolean.valueOf(work)), 3);
        }
    }

    private void stopPedestalAnimation(BlockPos pos) {
        List<BlockPos> pedestalPositions = List.of(pos.m_122013_(2), pos.m_122020_(2), pos.m_122030_(2).m_122013_(1), pos.m_122030_(2).m_122020_(1), pos.m_122025_(2).m_122020_(1), pos.m_122025_(2).m_122013_(1));
        pedestalPositions.forEach(pedestalPos -> {
            try {
                this.f_58857_.m_7731_(pedestalPos, (BlockState)this.f_58857_.m_8055_(pedestalPos).m_61124_((Property)BasePedestal.WORK, (Comparable)Boolean.valueOf(false)), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<InfuserRecipes> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(0, recipe.get().getInputCount(), false);
        ItemStack newStack = new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(1).m_41613_() + result.m_41613_());
        if (this.recipeOutput.m_41782_()) {
            newStack.m_41751_(result.m_41783_());
        }
        this.itemHandler.setStackInSlot(1, newStack);
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11930_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void summonLightning(BlockPos pos) {
        LightningBolt lightning;
        if (!this.f_58857_.m_5776_() && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_58857_)) != null && !this.isRedstonePowered(pos)) {
            lightning.m_6027_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
            lightning.m_20874_(true);
            lightning.m_5496_(SoundEvents.f_144242_, 1.0f, 1.0f);
            this.f_58857_.m_7967_((Entity)lightning);
        }
    }

    private boolean hasRecipe(BlockPos pos) {
        Optional<InfuserRecipes> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.f_41583_;
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.recipeOutput = result.m_41777_();
        if (!this.itemHandler.getStackInSlot(1).m_41619_() && this.recipeOutput != this.itemHandler.getStackInSlot(1)) {
            return false;
        }
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_()) && this.hasPedestals(pos, recipe.get().getPedestals());
    }

    private boolean hasPedestals(BlockPos pos, int[] pedestals) {
        Map<Integer, BlockPos> pedestalPositions = Map.of(1, pos.m_122025_(2).m_122020_(1), 2, pos.m_122025_(2).m_122013_(1), 3, pos.m_122013_(2), 4, pos.m_122030_(2).m_122013_(1), 5, pos.m_122030_(2).m_122020_(1), 6, pos.m_122020_(2));
        for (int pedestalIndex : pedestals) {
            boolean isValid;
            BlockPos pedestalPos = pedestalPositions.get(pedestalIndex);
            if (pedestalPos == null) {
                return false;
            }
            switch (pedestalIndex) {
                case 1: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof TechPedestalBlockEntity;
                    break;
                }
                case 2: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof ResourcePedestalBlockEntity;
                    break;
                }
                case 3: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof MagicPedestalBlockEntity;
                    break;
                }
                case 4: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof DecorPedestalBlockEntity;
                    break;
                }
                case 5: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof CreativityPedestalBlockEntity;
                    break;
                }
                case 6: {
                    boolean bl = this.f_58857_.m_7702_(pedestalPos) instanceof ExplorationPedestalBlockEntity;
                    break;
                }
                default: {
                    boolean bl = isValid = false;
                }
            }
            if (isValid) continue;
            return false;
        }
        return true;
    }

    private Optional<InfuserRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)InfuserRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item) && this.itemHandler.getStackInSlot(1).m_41783_().m_128456_();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void removeStack(ItemStack copy, InfuserBlockEntity blockEntity, Player player, int slot) {
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.itemHandler.getStackInSlot(slot).m_41777_()));
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
    }

    public void addStack(ItemStack copy, InfuserBlockEntity blockEntity, Player player, int slot) {
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            this.itemHandler.setStackInSlot(0, copy);
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Infuser.LIT, (Comparable)Integer.valueOf(0)), 3);
            player.m_21205_().m_41764_(0);
        }
    }
}

