/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.items.custom.ComponentItem;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.MatterCondenser;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.MatterCondenserHandler;
import com.Infinity.Nexus.Mod.item.ModItemsProgression;
import com.Infinity.Nexus.Mod.screen.condenser.CondenserMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterCondenserBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            MatterCondenserBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_150930_((Item)ModItemsProgression.RESIDUAL_MATTER.get());
                case 1 -> false;
                case 2 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int COMPONENT_SLOT = 2;
    private static final int CAPACITY = 0x7FFFFFF8;
    private static final int TRANSFER = 0x7FFFFFF8;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private static final int ENERGY_REQ = 1;
    private static final int EXTRATED_ENERGY = 429496;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.UP), MatterCondenserHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.DOWN), MatterCondenserHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.NORTH), MatterCondenserHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.SOUTH), MatterCondenserHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.EAST), MatterCondenserHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MatterCondenserHandler.extract(i, Direction.WEST), MatterCondenserHandler::insert)));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> MatterCondenserBlockEntity.this.progress;
                case 1 -> MatterCondenserBlockEntity.this.maxProgress;
                case 2 -> MatterCondenserBlockEntity.this.catalystLevel;
                case 3 -> MatterCondenserBlockEntity.this.amplifier;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    MatterCondenserBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    MatterCondenserBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    MatterCondenserBlockEntity.this.catalystLevel = pValue;
                    break;
                }
                case 3: {
                    MatterCondenserBlockEntity.this.amplifier = pValue;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 0x6666666;
    private int catalystLevel = 0;
    private int amplifier = 0;

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(0x7FFFFFF8, 0xCCCCCCC){

            public void onEnergyChanged() {
                MatterCondenserBlockEntity.this.m_6596_();
                MatterCondenserBlockEntity.this.m_58904_().m_7260_(MatterCondenserBlockEntity.this.m_58899_(), MatterCondenserBlockEntity.this.m_58900_(), MatterCondenserBlockEntity.this.m_58900_(), 4);
            }
        };
    }

    public MatterCondenserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MATTER_CONDENSER_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)MatterCondenser.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public static int getComponentSlot() {
        return 2;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        ItemStack catalystStack = new ItemStack((ItemLike)ModItemsProgression.RESIDUAL_MATTER.get());
        catalystStack.m_41764_(this.catalystLevel);
        ItemEntity catalyst = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, catalystStack);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        this.f_58857_.m_7967_((Entity)catalyst);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.matter_condenser").m_130946_(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CondenserMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getCatalystLevel() {
        return this.catalystLevel;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("matter_condenser.progress", this.progress);
        pTag.m_128405_("matter_condenser.catalyst_level", this.catalystLevel);
        pTag.m_128405_("matter_condenser.amplifier", this.amplifier);
        pTag.m_128405_("matter_condenser.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("matter_condenser.progress");
        this.catalystLevel = pTag.m_128451_("matter_condenser.catalyst_level");
        this.amplifier = pTag.m_128451_("matter_condenser.amplifier");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("matter_condenser.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        this.increaseCatalystLevel();
        int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MatterCondenser.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (!this.hasFreeSlot()) {
            return;
        }
        if (!(this.itemHandler.getStackInSlot(2).m_41720_() instanceof ComponentItem)) {
            return;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MatterCondenser.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress(machineLevel);
        MatterCondenserBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.resetProgress();
        }
    }

    private boolean hasFreeSlot() {
        return this.canInsertItemIntoOutputSlot((Item)ModItemsProgression.UNSTABLE_MATTER.get()) && this.canInsertAmountIntoOutputSlot(1);
    }

    private void increaseCatalystLevel() {
        if (this.itemHandler.getStackInSlot(0).m_150930_((Item)ModItemsProgression.RESIDUAL_MATTER.get()) && this.catalystLevel < 500000) {
            this.itemHandler.extractItem(0, 1, false);
            ++this.catalystLevel;
        }
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 1;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        ItemStack component = this.itemHandler.getStackInSlot(2);
        ModUtils.useComponent((ItemStack)component, (Level)this.f_58857_, (BlockPos)this.m_58899_());
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ModItemsProgression.UNSTABLE_MATTER.get(), this.itemHandler.getStackInSlot(1).m_41613_() + 1));
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11739_, SoundSource.BLOCKS, 0.1f, 1.0f);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(2));
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress(int machineLevel) {
        int extractedEnergy;
        int energyStored = this.ENERGY_STORAGE.getEnergyStored();
        if (energyStored >= (extractedEnergy = Math.min(429496 * (machineLevel + 1), energyStored))) {
            if (this.catalystLevel > 0 && this.amplifier <= 0) {
                --this.catalystLevel;
                this.amplifier = 20;
            }
            if (this.amplifier > 0) {
                this.progress += (int)((float)extractedEnergy * 1.2f);
                extractedEnergy = (int)((double)extractedEnergy * 0.8);
                --this.amplifier;
            } else {
                this.progress += extractedEnergy;
            }
            this.extractEnergy(extractedEnergy);
        }
    }

    private void extractEnergy(int extractedEnergy) {
        this.ENERGY_STORAGE.extractEnergy(Math.max(extractedEnergy, 1), false);
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)2, (ItemStackHandler)this.itemHandler);
    }
}

