/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.fakePlayer.IFFakePlayer;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Miner.utils.ModUtilsMiner;
import com.Infinity.Nexus.Mod.block.custom.MobCrusher;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.MobCrusherHandler;
import com.Infinity.Nexus.Mod.fluid.ModFluids;
import com.Infinity.Nexus.Mod.screen.mobcrusher.MobCrusherMenu;
import com.Infinity.Nexus.Mod.utils.ModUtilsMachines;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobCrusherBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int[] OUTPUT_SLOT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] UPGRADE_SLOTS = new int[]{9, 10, 11, 12};
    private static final int COMPONENT_SLOT = 13;
    private static final int SWORD_SLOT = 14;
    private static final int LINK_SLOT = 15;
    private static final int FUEL_SLOT = 16;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 120;
    private int hasRedstoneSignal = 0;
    private int stillCrafting = 0;
    private int hasSlotFree = 0;
    private int hasComponent = 0;
    private int hasEnoughEnergy = 0;
    private int hasRecipe = 0;
    private int linkx = 0;
    private int linky = 0;
    private int linkz = 0;
    private int linkFace = 0;
    private static final int ENERGY_CAPACITY = 60000;
    private static final int ENERGY_TRANSFER = 640;
    private static final int ENERGY_REQ = 32;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private static final int FluidStorageCapacity = 10000;
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final ItemStackHandler itemHandler = new ItemStackHandler(17){

        protected void onContentsChanged(int slot) {
            MobCrusherBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 9, 10, 11, 12 -> ModUtils.isUpgrade((ItemStack)stack);
                case 13 -> ModUtils.isComponent((ItemStack)stack);
                case 14 -> stack.m_41720_() instanceof SwordItem;
                case 15 -> stack.m_150930_(((Item)ModItems.LINKING_TOOL.get()).m_5456_());
                case 16 -> {
                    if (ForgeHooks.getBurnTime((ItemStack)stack, null) > 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.UP), MobCrusherHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.DOWN), MobCrusherHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.NORTH), MobCrusherHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.SOUTH), MobCrusherHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.EAST), MobCrusherHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> MobCrusherHandler.extract(i, Direction.WEST), MobCrusherHandler::insert)));
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(60000, 640){

        public void onEnergyChanged() {
            MobCrusherBlockEntity.this.m_6596_();
            MobCrusherBlockEntity.this.m_58904_().m_7260_(MobCrusherBlockEntity.this.m_58899_(), MobCrusherBlockEntity.this.m_58900_(), MobCrusherBlockEntity.this.m_58900_(), 4);
        }
    };
    private boolean showArea = false;

    private FluidTank createFluidStorage() {
        return new FluidTank(10000){

            protected void onContentsChanged() {
                MobCrusherBlockEntity.this.m_6596_();
                if (!MobCrusherBlockEntity.this.m_58904_().f_46443_) {
                    MobCrusherBlockEntity.this.m_58904_().m_7260_(MobCrusherBlockEntity.this.m_58899_(), MobCrusherBlockEntity.this.m_58900_(), MobCrusherBlockEntity.this.m_58900_(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    public MobCrusherBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MOBCRUSHER_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> MobCrusherBlockEntity.this.progress;
                    case 1 -> MobCrusherBlockEntity.this.maxProgress;
                    case 2 -> MobCrusherBlockEntity.this.hasRedstoneSignal;
                    case 3 -> MobCrusherBlockEntity.this.stillCrafting;
                    case 4 -> MobCrusherBlockEntity.this.hasSlotFree;
                    case 5 -> MobCrusherBlockEntity.this.hasComponent;
                    case 6 -> MobCrusherBlockEntity.this.hasEnoughEnergy;
                    case 7 -> MobCrusherBlockEntity.this.hasRecipe;
                    case 8 -> MobCrusherBlockEntity.this.linkx;
                    case 9 -> MobCrusherBlockEntity.this.linky;
                    case 10 -> MobCrusherBlockEntity.this.linkz;
                    case 11 -> MobCrusherBlockEntity.this.linkFace;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        MobCrusherBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        MobCrusherBlockEntity.this.maxProgress = pValue;
                        break;
                    }
                    case 2: {
                        MobCrusherBlockEntity.this.hasRedstoneSignal = pValue;
                        break;
                    }
                    case 3: {
                        MobCrusherBlockEntity.this.stillCrafting = pValue;
                        break;
                    }
                    case 4: {
                        MobCrusherBlockEntity.this.hasSlotFree = pValue;
                        break;
                    }
                    case 5: {
                        MobCrusherBlockEntity.this.hasComponent = pValue;
                        break;
                    }
                    case 6: {
                        MobCrusherBlockEntity.this.hasEnoughEnergy = pValue;
                        break;
                    }
                    case 7: {
                        MobCrusherBlockEntity.this.hasRecipe = pValue;
                        break;
                    }
                    case 8: {
                        MobCrusherBlockEntity.this.linkx = pValue;
                        break;
                    }
                    case 9: {
                        MobCrusherBlockEntity.this.linky = pValue;
                        break;
                    }
                    case 10: {
                        MobCrusherBlockEntity.this.linkz = pValue;
                        break;
                    }
                    case 11: {
                        MobCrusherBlockEntity.this.linkFace = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 12;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)MobCrusher.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("mobCrusher.progress", this.progress);
        pTag.m_128405_("mobCrusher.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag = this.FLUID_STORAGE.writeToNBT(pTag);
        pTag.m_128405_("mobCrusher.hasRedstoneSignal", this.getHasRedstoneSignal());
        pTag.m_128405_("mobCrusher.stillCrafting", this.getStillCrafting());
        pTag.m_128405_("mobCrusher.hasSlotFree", this.getHasSlotFree());
        pTag.m_128405_("mobCrusher.hasComponent", this.getHasComponent());
        pTag.m_128405_("mobCrusher.hasEnoughEnergy", this.getHasEnoughEnergy());
        pTag.m_128405_("mobCrusher.hasRecipe", this.getHasRecipe());
        pTag.m_128405_("miner.linkx", this.data.m_6413_(8));
        pTag.m_128405_("miner.linky", this.data.m_6413_(9));
        pTag.m_128405_("miner.linkz", this.data.m_6413_(10));
        pTag.m_128405_("miner.linkFace", this.data.m_6413_(11));
        pTag.m_128379_("mobCrusher.showArea", this.showArea);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("mobCrusher.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("mobCrusher.energy"));
        this.FLUID_STORAGE.readFromNBT(pTag);
        this.hasRedstoneSignal = pTag.m_128451_("mobCrusher.hasRedstoneSignal");
        this.stillCrafting = pTag.m_128451_("mobCrusher.stillCrafting");
        this.hasSlotFree = pTag.m_128451_("mobCrusher.hasSlotFree");
        this.hasComponent = pTag.m_128451_("mobCrusher.hasComponent");
        this.hasEnoughEnergy = pTag.m_128451_("mobCrusher.hasEnoughEnergy");
        this.hasRecipe = pTag.m_128451_("mobCrusher.hasRecipe");
        this.linkx = pTag.m_128451_("miner.linkx");
        this.linky = pTag.m_128451_("miner.linky");
        this.linkz = pTag.m_128451_("miner.linkz");
        this.linkFace = pTag.m_128451_("miner.linkFace");
        this.showArea = pTag.m_128471_("mobCrusher.showArea");
    }

    public static int getComponentSlot() {
        return 13;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.mob_crusher").m_130946_(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        return new MobCrusherMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static long getFluidCapacity() {
        return 10000L;
    }

    public FluidStack getFluid() {
        return this.FLUID_STORAGE.getFluid();
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public int getHasRedstoneSignal() {
        return this.data.m_6413_(2);
    }

    public int getStillCrafting() {
        return this.data.m_6413_(3);
    }

    public int getHasSlotFree() {
        return this.data.m_6413_(4);
    }

    public int getHasComponent() {
        return this.data.m_6413_(5);
    }

    public int getHasEnoughEnergy() {
        return this.data.m_6413_(6);
    }

    public int getHasRecipe() {
        return this.data.m_6413_(7);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        this.renderAreaPreview(level, pos);
        int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        state = (BlockState)state.m_61124_((Property)MobCrusher.LIT, (Comparable)Integer.valueOf(machineLevel));
        if (this.isRedstonePowered(pos)) {
            this.data.m_8050_(2, 1);
            return;
        }
        this.data.m_8050_(2, 0);
        this.setMaxProgress();
        if (!this.hasEnoughEnergy()) {
            this.verifySolidFuel();
            this.data.m_8050_(6, 0);
            return;
        }
        this.data.m_8050_(6, 1);
        if (this.hasMobInside(machineLevel, pos, level)) {
            this.data.m_8050_(7, 1);
            this.increaseCraftingProgress();
            if (this.hasProgressFinished()) {
                this.data.m_8050_(3, 1);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MobCrusher.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
                this.verifyMobs(level, pos, machineLevel);
                this.extractEnergy(this);
                MobCrusherBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                this.resetProgress();
            }
            this.data.m_8050_(3, 0);
        } else {
            this.data.m_8050_(7, 0);
        }
    }

    private boolean hasMobInside(int machinelevel, BlockPos pPos, Level pLevel) {
        ArrayList mobs;
        return !(mobs = new ArrayList(pLevel.m_45976_(Mob.class, new AABB(pPos.m_7918_(++machinelevel * -1, 1, machinelevel * -1), pPos.m_7918_(machinelevel, 3, machinelevel))))).isEmpty();
    }

    private void extractEnergy(MobCrusherBlockEntity mobCrusherBlockEntity) {
        int machineLevel = this.getMachineLevel() + 1;
        int maxProgress = mobCrusherBlockEntity.maxProgress;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) + 1;
        int strength = ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) * 10;
        int var1 = machineLevel * 20 / maxProgress * (speed + machineLevel);
        int var2 = Math.multiplyExact(strength, var1 / 100);
        int extractEnergy = var1 - var2;
        mobCrusherBlockEntity.ENERGY_STORAGE.extractEnergy(Math.max(extractEnergy, 1), false);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public int getMachineLevel() {
        if (ModUtils.isComponent((ItemStack)this.itemHandler.getStackInSlot(13))) {
            this.data.m_8050_(5, ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(13)));
        } else {
            this.data.m_8050_(5, 0);
        }
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(13));
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void setMaxProgress() {
        this.maxProgress = 20;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void execute(Mob mob, BlockPos pPos, int machineLevel) {
        IFFakePlayer player = ModUtilsMachines.getFakePlayer((ServerLevel)this.f_58857_);
        player.m_21008_(InteractionHand.MAIN_HAND, this.itemHandler.getStackInSlot(14));
        ServerPlayer randomPlayer = ((ServerLevel)this.f_58857_).m_8890_();
        DamageSource source = player.m_269291_().m_269075_((Player)(randomPlayer != null && machineLevel >= 7 ? randomPlayer : player));
        LootTable table = Objects.requireNonNull(this.f_58857_.m_7654_()).m_278653_().m_278676_(mob.m_5743_());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81457_, (Object)source).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_())).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81456_, (Object)player).m_287289_(LootContextParams.f_81459_, (Object)player);
        table.m_287195_(context.m_287235_(LootContextParamSets.f_81415_)).forEach(stack -> {
            this.insertItemOnInventory((ItemStack)stack);
            for (int loot = 0; loot < machineLevel; ++loot) {
                int rand = RandomSource.m_216327_().m_188503_(10);
                if (rand != 0) continue;
                this.insertItemOnInventory((ItemStack)stack);
            }
        });
        ArrayList extra = new ArrayList();
        try {
            if (mob.captureDrops() == null) {
                mob.captureDrops(new ArrayList());
            }
            ObfuscationReflectionHelper.findMethod(Mob.class, (String)"m_7472_", (Class[])new Class[]{DamageSource.class, Integer.TYPE, Boolean.TYPE}).invoke((Object)mob, source, 0, true);
            if (mob.captureDrops() != null) {
                extra.addAll(mob.captureDrops());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        ForgeHooks.onLivingDrops((LivingEntity)mob, (DamageSource)source, extra, (int)3, (boolean)true);
        player.m_5706_((Entity)mob);
        extra.forEach(itemEntity -> {
            this.insertItemOnInventory(itemEntity.m_32055_());
            itemEntity.m_142687_(Entity.RemovalReason.KILLED);
        });
        mob.m_21153_(0.0f);
        ModUtilsMachines.sendParticlePath((ServerLevel)this.m_58904_(), ParticleTypes.f_175830_, this.f_58858_.m_7494_(), mob.m_20097_().m_6630_(2), 0.5, 0.2, 0.5);
        this.insertExpense(mob.m_213860_());
    }

    private void insertExpense(int experienceReward) {
        FluidStack fluidStack = new FluidStack((Fluid)ModFluids.EXPERIENCE_SOURCE.get(), experienceReward);
        this.FLUID_STORAGE.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void verifyMobs(Level pLevel, BlockPos pPos, int machinelevel) {
        try {
            ArrayList entities = new ArrayList(pLevel.m_45976_(Mob.class, new AABB(pPos.m_7918_(++machinelevel * -1, 0, machinelevel * -1), pPos.m_7918_(machinelevel, 3, machinelevel))));
            this.data.m_8050_(4, 0);
            if (!entities.isEmpty()) {
                boolean hasFreeSlots = this.hasFreeSlots();
                if (!hasFreeSlots && entities.size() > 30) {
                    if (this.hasProgressFinished()) {
                        this.insertItemOnInventory(ItemStack.f_41583_);
                    }
                    entities.forEach(Entity::m_146870_);
                    this.notifyOwner();
                } else if (hasFreeSlots) {
                    this.data.m_8050_(4, 1);
                    for (Mob entity : entities) {
                        if (entity == null || entity.m_8077_() || EntityType.m_20613_((EntityType)entity.m_6095_()).m_135815_().equalsIgnoreCase("maid") || !entity.m_6084_()) continue;
                        this.execute(entity, pPos, machinelevel);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7f[INM\u00a7f]\u00a74: Failed to kill mobs in: " + pPos);
            e.printStackTrace();
        }
    }

    private void insertItemOnInventory(ItemStack itemStack) {
        try {
            if (this.itemHandler.getStackInSlot(15).m_150930_((Item)ModItems.LINKING_TOOL.get())) {
                ItemStack linkingTool = this.itemHandler.getStackInSlot(15).m_41777_();
                AtomicBoolean success = new AtomicBoolean(false);
                String name = linkingTool.m_41611_().getString();
                this.data.m_8050_(8, 0);
                this.data.m_8050_(9, 0);
                this.data.m_8050_(10, 0);
                if (linkingTool.m_41788_()) {
                    String[] parts = name.substring(1, name.length() - 1).split(",");
                    int xl = 0;
                    int yl = 0;
                    int zl = 0;
                    String facel = "up";
                    for (String part : parts) {
                        String[] keyValue = part.split("=");
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        if (key.equals("x")) {
                            xl = Integer.parseInt(value);
                            this.data.m_8050_(8, xl);
                            continue;
                        }
                        if (key.equals("y")) {
                            yl = Integer.parseInt(value);
                            this.data.m_8050_(9, yl);
                            continue;
                        }
                        if (key.equals("z")) {
                            zl = Integer.parseInt(value);
                            this.data.m_8050_(10, zl);
                            continue;
                        }
                        if (!key.equals("face")) continue;
                        facel = value;
                    }
                    BlockEntity blockEntity = this.f_58857_.m_7702_(new BlockPos(xl, yl, zl));
                    BlockPos targetPos = new BlockPos(xl, yl, zl);
                    if (blockEntity.m_58899_().equals((Object)this.m_58899_())) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)xl, (double)(yl + 1), (double)zl, this.itemHandler.getStackInSlot(15).m_41777_()));
                        this.itemHandler.extractItem(15, 1, false);
                    }
                    if (!this.itemHandler.getStackInSlot(OUTPUT_SLOT[7]).m_41619_()) {
                        if (blockEntity != null && this.canLink(blockEntity)) {
                            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, ModUtilsMiner.getLinkedSide((String)facel)).ifPresent(iItemHandler -> {
                                int slot;
                                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                                    if (!ModUtils.canPlaceItemInContainer((ItemStack)itemStack.m_41777_(), (int)slot, (IItemHandler)iItemHandler) || !iItemHandler.isItemValid(slot, itemStack.m_41777_())) continue;
                                    iItemHandler.insertItem(slot, itemStack.m_41777_(), false);
                                    ModUtilsMachines.sendParticlePath((ServerLevel)this.m_58904_(), ParticleTypes.f_175831_, this.f_58858_.m_7494_(), targetPos, 0.5, 0.2, 0.5);
                                    success.set(true);
                                    break;
                                }
                                block1: for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                                    for (int outputSlot : OUTPUT_SLOT) {
                                        if (this.itemHandler.getStackInSlot(outputSlot).m_41619_() || !iItemHandler.isItemValid(slot, itemStack.m_41777_()) || !ModUtils.canPlaceItemInContainer((ItemStack)this.itemHandler.getStackInSlot(outputSlot).m_41777_(), (int)slot, (IItemHandler)iItemHandler)) continue;
                                        iItemHandler.insertItem(slot, this.itemHandler.getStackInSlot(outputSlot).m_41777_(), false);
                                        this.itemHandler.extractItem(outputSlot, this.itemHandler.getStackInSlot(outputSlot).m_41613_(), false);
                                        success.set(true);
                                        continue block1;
                                    }
                                }
                            });
                        } else {
                            ModUtils.ejectItemsWhePusher((BlockPos)this.f_58858_.m_7494_(), (int[])UPGRADE_SLOTS, (int[])OUTPUT_SLOT, (ItemStackHandler)this.itemHandler, (Level)this.f_58857_);
                        }
                    }
                }
                if (!success.get()) {
                    this.insertItemOnSelfInventory(itemStack);
                }
            } else {
                this.insertItemOnSelfInventory(itemStack);
            }
        }
        catch (Exception e) {
            System.out.println("\u00a7f[INM\u00a7f]\u00a7c: Failed to insert item in: " + this.m_58899_());
        }
    }

    private void insertItemOnSelfInventory(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        for (int slot : OUTPUT_SLOT) {
            ItemStack existingStack = this.itemHandler.getStackInSlot(slot);
            if (existingStack.m_41619_() || !ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)itemStack) || existingStack.m_41613_() >= existingStack.m_41741_()) continue;
            int spaceAvailable = existingStack.m_41741_() - existingStack.m_41613_();
            int amountToAdd = Math.min(spaceAvailable, itemStack.m_41613_());
            existingStack.m_41769_(amountToAdd);
            itemStack.m_41774_(amountToAdd);
            if (!itemStack.m_41619_()) continue;
            return;
        }
        for (int slot : OUTPUT_SLOT) {
            if (!this.itemHandler.getStackInSlot(slot).m_41619_()) continue;
            this.itemHandler.insertItem(slot, itemStack.m_41777_(), false);
            return;
        }
    }

    private boolean canLink(BlockEntity blockEntity) {
        return (int)Math.sqrt(this.m_58899_().m_123331_((Vec3i)blockEntity.m_58899_())) < 100;
    }

    public String getHasLink() {
        if (this.data.m_6413_(8) != 0 || this.data.m_6413_(9) != 0 || this.data.m_6413_(10) != 0) {
            return "X: " + this.data.m_6413_(8) + ", Y: " + this.data.m_6413_(9) + ", Z: " + this.data.m_6413_(10);
        }
        return "[Unlinked]";
    }

    public ItemStack getLikedBlock() {
        return new ItemStack((ItemLike)this.f_58857_.m_8055_(new BlockPos(this.data.m_6413_(8), this.data.m_6413_(9), this.data.m_6413_(10))).m_60734_().m_5456_());
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)13, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }

    public void setShowArea(boolean show) {
        this.showArea = show;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean shouldShowArea() {
        return this.showArea;
    }

    private void renderAreaPreview(Level level, BlockPos pos) {
        if (!this.showArea || !level.m_5776_()) {
            return;
        }
        int machineLevel = this.getMachineLevel();
        if (machineLevel <= 0) {
            return;
        }
        int range = machineLevel;
        BlockPos start = pos.m_7494_();
        this.renderCubeEdges(level, start, range);
    }

    private void renderCubeEdges(Level level, BlockPos start, int range) {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    if (!this.isEdgePosition(x, y, z, range)) continue;
                    this.spawnEdgeParticle(level, start, x, y, z);
                }
            }
        }
    }

    private void spawnEdgeParticle(Level level, BlockPos start, int x, int y, int z) {
        if (level.f_46441_.m_188501_() < 0.5f) {
            double particleX = (double)(start.m_123341_() + x) + 0.5;
            double particleY = start.m_123342_() + y;
            double particleZ = (double)(start.m_123343_() + z) + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, particleX, particleY, particleZ, 0.0, 0.01, 0.0);
        }
    }

    private boolean isEdgePosition(int x, int y, int z, int range) {
        if (Math.abs(x) == range && Math.abs(z) == range) {
            return true;
        }
        if (y == 0 || y == 2) {
            return Math.abs(x) == range || Math.abs(z) == range;
        }
        return false;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            return;
        }
        if (this.showArea) {
            this.renderAreaPreview(level, pos);
        }
    }

    private boolean hasFreeSlots() {
        for (int slot : OUTPUT_SLOT) {
            if (!this.itemHandler.getStackInSlot(slot).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private void notifyOwner() {
    }

    private void verifySolidFuel() {
        ItemStack slotItem = this.itemHandler.getStackInSlot(16);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)slotItem, null);
        if (burnTime > 1) {
            while (this.itemHandler.getStackInSlot(16).m_41613_() > 0 && this.getEnergyStorage().getEnergyStored() + burnTime < this.getEnergyStorage().getMaxEnergyStored()) {
                this.getEnergyStorage().receiveEnergy(burnTime, false);
                this.itemHandler.extractItem(16, 1, false);
            }
        }
    }

    private void handleLinkedInsertion(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        BlockEntity targetEntity = this.f_58857_.m_7702_(new BlockPos(this.data.m_6413_(8), this.data.m_6413_(9), this.data.m_6413_(10)));
        if (targetEntity == null) {
            return;
        }
        targetEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                if (!handler.isItemValid(slot, stack)) continue;
                ItemStack remaining = handler.insertItem(slot, stack.m_41777_(), false);
                stack.m_41764_(remaining.m_41613_());
                if (stack.m_41619_()) break;
            }
        });
    }
}

