/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.fakePlayer.IFFakePlayer;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Placer;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.PlacerHandler;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.placer.PlacerMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            PlacerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int COMPONENT_SLOT = 1;
    private int progress = 0;
    private int maxProgress = 20;
    private int blocked = 0;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.UP), PlacerHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.DOWN), PlacerHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.NORTH), PlacerHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.SOUTH), PlacerHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.EAST), PlacerHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> PlacerHandler.extract(i, Direction.WEST), PlacerHandler::insert)));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> PlacerBlockEntity.this.progress;
                case 1 -> PlacerBlockEntity.this.maxProgress;
                case 2 -> PlacerBlockEntity.this.blocked;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    PlacerBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    PlacerBlockEntity.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    PlacerBlockEntity.this.blocked = pValue;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public PlacerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.PLACER_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Placer.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public static int getComponentSlot() {
        return 1;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.placer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PlacerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("placer.progress", this.progress);
        pTag.m_128405_("placer.max_progress", this.maxProgress);
        pTag.m_128405_("placer.blocked", this.blocked);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("placer.progress");
        this.maxProgress = pTag.m_128451_("placer.max_progress");
        this.blocked = pTag.m_128451_("placer.blocked");
    }

    public ItemStack getRenderStack(int slot) {
        return this.itemHandler.getStackInSlot(slot).m_41619_() ? ItemStack.f_41583_ : this.itemHandler.getStackInSlot(slot).m_41720_().m_7968_();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        int machineLevel;
        if (pLevel.m_5776_()) {
            return;
        }
        int n = machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        if ((Integer)pState.m_61143_((Property)Placer.LIT) != machineLevel) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Placer.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        }
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.increaseProgress();
        if (!this.hasProgressFinished()) {
            return;
        }
        this.resetProgress();
        if (!this.hasRecipe(pPos)) {
            this.data.m_8050_(2, 1);
            return;
        }
        this.data.m_8050_(2, 0);
        this.craft(pLevel, pPos, pState, machineLevel);
        PlacerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 20;
    }

    private void increaseProgress() {
        if (this.progress < this.maxProgress) {
            ++this.progress;
        }
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void craft(Level pLevel, BlockPos pPos, BlockState pState, int machineLevel) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)pLevel;
            Direction direction = (Direction)pState.m_61143_((Property)Placer.FACING);
            BlockPos placePos = this.getPlacePos(pPos, direction);
            if (!this.hasEntity(placePos)) {
                ItemStack stack = this.itemHandler.getStackInSlot(0).m_41777_();
                IFFakePlayer player = new IFFakePlayer(level);
                player.placeBlock(this.f_58857_, placePos, stack, direction);
                this.itemHandler.extractItem(0, 1, false);
            }
        }
    }

    private boolean hasEntity(BlockPos pPos) {
        return !this.f_58857_.m_45976_(Player.class, new AABB(pPos)).isEmpty();
    }

    private boolean canPlace(ItemStack stack) {
        return !ConfigUtils.list_of_non_placeable_blocks.stream().map(structure -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(structure))).anyMatch(structureItem -> structureItem == stack.m_41720_());
    }

    private boolean isFree(BlockPos pPos) {
        return this.f_58857_.m_8055_(pPos) == Blocks.f_50016_.m_49966_();
    }

    private BlockPos getPlacePos(BlockPos pPos, Direction pDirection) {
        return switch (pDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> pPos.m_7495_();
            case Direction.UP -> pPos.m_7494_();
            case Direction.NORTH -> pPos.m_122012_();
            case Direction.SOUTH -> pPos.m_122019_();
            case Direction.WEST -> pPos.m_122024_();
            case Direction.EAST -> pPos.m_122029_();
        };
    }

    private boolean hasRecipe(BlockPos pPos) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return this.itemHandler.getStackInSlot(1).m_41613_() > 0 && stack.m_41720_() instanceof BlockItem && this.isFree(this.getPlacePos(pPos, (Direction)this.m_58900_().m_61143_((Property)Placer.FACING))) && !stack.m_41782_() && this.canPlace(stack);
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private int getMachineLevel() {
        try {
            return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(1));
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)1, (ItemStackHandler)this.itemHandler);
    }
}

