/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Smeltery;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.SmelteryHandler;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.SmelteryRecipes;
import com.Infinity.Nexus.Mod.screen.smeltery.SmelteryMenu;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmelteryBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SmelteryBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> false;
                case 4, 5, 6, 7 -> ModUtils.isUpgrade((ItemStack)stack);
                case 8 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int[] UPGRADE_SLOTS = new int[]{4, 5, 6, 7};
    private static final int COMPONENT_SLOT = 8;
    private static final int capacity = 60000;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private static final int ENERGY_REQ = 32;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.UP), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.DOWN), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.NORTH), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.SOUTH), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.EAST), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SmelteryHandler.extract(i, Direction.WEST), (i, s) -> SmelteryHandler.insert(i, s) && this.itemHandler.getStackInSlot(i.intValue()).m_41619_())));
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 0;
    public ItemStack recipeOutput = ItemStack.f_41583_;

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(60000, 640){

            public void onEnergyChanged() {
                SmelteryBlockEntity.this.m_6596_();
                SmelteryBlockEntity.this.m_58904_().m_7260_(SmelteryBlockEntity.this.m_58899_(), SmelteryBlockEntity.this.m_58900_(), SmelteryBlockEntity.this.m_58900_(), 4);
            }
        };
    }

    public SmelteryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SMELTERY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> SmelteryBlockEntity.this.progress;
                    case 1 -> SmelteryBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        SmelteryBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        SmelteryBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Smeltery.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public static int getComponentSlot() {
        return 8;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.smeltery").m_130946_(" LV " + this.getMachineLevel());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SmelteryMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("smeltery.progress", this.progress);
        pTag.m_128405_("smeltery.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag.m_128365_("recipeOutput", (Tag)this.recipeOutput.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("smeltery.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("smeltery.energy"));
        this.recipeOutput = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("recipeOutput"));
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Smeltery.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        if (!this.hasRecipe()) {
            this.resetProgress();
            return;
        }
        this.setMaxProgress(machineLevel);
        if (!this.hasEnoughEnergy()) {
            return;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Smeltery.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
        this.increaseCraftingProgress();
        this.extractEnergy(this);
        SmelteryBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        if (this.hasProgressFinished()) {
            this.craftItem();
            ModUtils.ejectItemsWhePusher((BlockPos)pPos.m_7494_(), (int[])UPGRADE_SLOTS, (int[])new int[]{3}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
            this.resetProgress();
        }
    }

    private void extractEnergy(SmelteryBlockEntity smelteryBlockEntity) {
        int energy = this.getCurrentRecipe().get().getEnergy();
        int machineLevel = this.getMachineLevel() + 1;
        int maxProgress = smelteryBlockEntity.maxProgress;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) + 1;
        int strength = ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) * 10;
        int var1 = (energy + machineLevel * 20) / maxProgress * (speed + machineLevel);
        int var2 = Math.multiplyExact(strength, var1 / 100);
        int extractEnergy = var1 - var2;
        smelteryBlockEntity.ENERGY_STORAGE.extractEnergy(Math.max(extractEnergy, 1), false);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= 32;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<SmelteryRecipes> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        int[] inputCount = recipe.get().getInputCount();
        for (int i = 1; i < recipe.get().m_7527_().size(); ++i) {
            this.itemHandler.extractItem(i - 1, inputCount[i], false);
        }
        ItemStack component = this.itemHandler.getStackInSlot(8);
        ModUtils.useComponent((ItemStack)component, (Level)this.f_58857_, (BlockPos)this.m_58899_());
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(3).m_41613_() + result.m_41613_()));
        if (ModUtils.getMuffler((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) < 1) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private boolean hasRecipe() {
        Optional<SmelteryRecipes> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.f_41583_;
            return false;
        }
        int[] inputCount = recipe.get().getInputCount();
        for (int i = 1; i < recipe.get().m_7527_().size(); ++i) {
            if (this.itemHandler.getStackInSlot(i - 1).m_41613_() >= inputCount[i]) continue;
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.recipeOutput = result.m_41777_();
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<SmelteryRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SmelteryRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(8));
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(3).m_41613_() + count <= this.itemHandler.getStackInSlot(3).m_41741_();
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void setMaxProgress(int machineLevel) {
        int duration = this.getCurrentRecipe().get().getDuration();
        int halfDuration = duration / 2;
        int speedReduction = halfDuration / 16;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
        int reducedDuration = speed * speedReduction;
        int reducedLevel = machineLevel * (halfDuration / 8);
        duration = duration - reducedDuration - reducedLevel;
        this.maxProgress = Math.max(duration, ConfigUtils.assembler_minimum_tick);
    }

    public static int getInputSlot() {
        return 2;
    }

    public static int getOutputSlot() {
        return 3;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)8, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

