/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Mod.block.custom.Solar;
import com.Infinity.Nexus.Mod.block.entity.GeneratorBlockEntity;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.custom.SolarUpgrade;
import com.Infinity.Nexus.Mod.screen.solar.SolarMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            SolarBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof SolarUpgrade;
        }
    };
    private static final int COMPONENT_SLOT = 0;
    private static final int ENERGY_TRANSFER = 5832;
    private static final int TRANSFER = 64000;
    private static final int CAPACITY = 512000;
    private static int GEM = 0;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> false, (i, s) -> !(s.m_41720_() instanceof SolarUpgrade))));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return GEM;
        }

        public void m_8050_(int pIndex, int pValue) {
            SolarBlockEntity.this.data.m_8050_(0, pValue);
        }

        public int m_6499_() {
            return 1;
        }
    };

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(512000, 64000){

            public void onEnergyChanged() {
                SolarBlockEntity.this.m_6596_();
                SolarBlockEntity.this.m_58904_().m_7260_(SolarBlockEntity.this.m_58899_(), SolarBlockEntity.this.m_58900_(), SolarBlockEntity.this.m_58900_(), 4);
            }
        };
    }

    public SolarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SOLAR_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Solar.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public boolean getTime() {
        return this.m_58904_().m_6106_().m_6792_() % 24000L < 12000L;
    }

    public static int getComponentSlot() {
        return 0;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return switch (this.getSolarLevel()) {
            case 0 -> Component.m_237115_((String)"block.infinity_nexus_mod.solar");
            case 1 -> Component.m_237115_((String)"item.infinity_nexus_mod.solar_pane");
            case 2 -> Component.m_237115_((String)"item.infinity_nexus_mod.solar_pane_advanced");
            case 3 -> Component.m_237115_((String)"item.infinity_nexus_mod.solar_pane_ultimate");
            case 4 -> Component.m_237115_((String)"item.infinity_nexus_mod.solar_pane_quantum");
            case 5 -> Component.m_237115_((String)"item.infinity_nexus_mod.solar_pane_photonic");
            default -> throw new IllegalStateException("Unexpected value: " + this.getSolarLevel());
        };
    }

    private int getSolarLevel() {
        int level = 0;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41720_() == ModItemsAdditions.SOLAR_PANE.get()) {
            level = 1;
        } else if (stack.m_41720_() == ModItemsAdditions.SOLAR_PANE_ADVANCED.get()) {
            level = 2;
        } else if (stack.m_41720_() == ModItemsAdditions.SOLAR_PANE_ULTIMATE.get()) {
            level = 3;
        } else if (stack.m_41720_() == ModItemsAdditions.SOLAR_PANE_QUANTUM.get()) {
            level = 4;
        } else if (stack.m_41720_() == ModItemsAdditions.SOLAR_PANE_PHOTONIC.get()) {
            level = 5;
        }
        return level;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SolarMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("solar.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("solar.energy"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.f_46443_) {
            return;
        }
        int level = this.getSolarLevel();
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Solar.LIT, (Comparable)Integer.valueOf(level)), 3);
        if (this.isRedstonePowered(pPos)) {
            return;
        }
        this.findEnergyCap();
        if (!this.hasUpgrade()) {
            return;
        }
        if (!this.hasRecipe()) {
            GEM = 0;
            return;
        }
        GEM = 1;
        if (!this.hasEnoughEnergySpace()) {
            return;
        }
        this.generateEnergy();
        SolarBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private boolean hasUpgrade() {
        return this.getSolarLevel() > 0;
    }

    private void generateEnergy() {
        this.ENERGY_STORAGE.receiveEnergy(this.getGenerationRate(), false);
    }

    public int getGenerationRate() {
        int level = this.getSolarLevel();
        int[] energy = new int[]{0, 8, 72, 648, 5832, 52488};
        return this.getTime() ? energy[level] : energy[level] / 8;
    }

    private void findEnergyCap() {
        try {
            Level level = this.m_58904_();
            BlockPos pos = this.m_58899_();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(direction);
                assert (level != null);
                BlockEntity neighborBlockEntity = level.m_7702_(neighborPos);
                if (neighborBlockEntity == null || neighborBlockEntity instanceof SolarBlockEntity || neighborBlockEntity instanceof GeneratorBlockEntity) continue;
                neighborBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                    int amount = Math.min(this.ENERGY_STORAGE.getEnergyStored(), 5832);
                    if (energy.canReceive() && energy.getEnergyStored() != energy.getMaxEnergyStored()) {
                        if (energy.getMaxEnergyStored() - energy.getEnergyStored() >= amount) {
                            energy.receiveEnergy(amount, false);
                            this.ENERGY_STORAGE.extractEnergy(amount, false);
                        } else {
                            energy.receiveEnergy(energy.getMaxEnergyStored() - energy.getEnergyStored(), false);
                            this.ENERGY_STORAGE.extractEnergy(energy.getMaxEnergyStored() - energy.getEnergyStored(), false);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            System.out.println("&f[INM&f]&4: Failed to find energy cap.");
            e.printStackTrace();
        }
    }

    private boolean hasEnoughEnergySpace() {
        return this.ENERGY_STORAGE.getEnergyStored() < this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    private boolean hasRecipe() {
        return this.m_58904_().m_45527_(this.m_58899_().m_7494_());
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setSolarLevel(ItemStack itemStack, Player player) {
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            ItemStack stack = itemStack.m_41777_();
            stack.m_41764_(1);
            this.itemHandler.setStackInSlot(0, stack);
            player.m_21205_().m_41774_(1);
            this.m_6596_();
        } else {
            ItemStack component = this.itemHandler.getStackInSlot(0);
            ItemStack stack = itemStack.m_41777_();
            stack.m_41764_(1);
            this.itemHandler.setStackInSlot(0, stack);
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), component);
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
                this.f_58857_.m_7967_((Entity)itemEntity);
            }
            this.m_6596_();
        }
        assert (this.f_58857_ != null);
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11679_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

